#include "log.h"
#include "stdio.h"
#include "mbed.h"
#include "stdarg.h"
Serial pc(USBTX, USBRX);
void vlogMessage(const char *,va_list);
/**
    Function: logMessage
    Description: output the message(can be formatted string) to PC
*/
void logMessage(const char *fmt,...){
    va_list args;
    va_start(args, fmt);
    vlogMessage( fmt, args );
    va_end(args);
}

void vlogMessage(const char *fmt,va_list args){
    char buffer[255];
    char msg[255];
    //get time stamp
    sprintf(buffer, "Time[seconds]: %.3f : ", programTimer.read_ms()/1000.0);

    vsprintf( msg, fmt, args );
    strcat( buffer, msg);
    pc.printf("%s \n", buffer);
}
