
#ifdef WIN32
#include "stdio.h"
#include "conio.h"
#include "string.h"
#include "assert.h"
#else
#include "mbed.h"
#endif
 
extern "C" {
#include "CommandProcessor.h"
}
 
#ifdef WIN32
#else
I2C i2c(PTE0, PTE1);
const int addr = 0x30;
DigitalOut red(LED1);
DigitalOut green(LED2);
DigitalOut blue(LED3);
Ticker flipper;
char cmd[2];
#endif
 
 void flip() {
    blue = !blue;
}

RUNRESULT_T Send(char *p);
const CMD_T SendCmd = {
    "send", 
    "Send bytes to I2C", 
    Send, 
    visible
};

RUNRESULT_T Read(char *p);
const CMD_T ReadCmd = {
    "read", 
    "Read bytes from I2C", 
    Read, 
    visible
};

RUNRESULT_T Who(char *p);
const CMD_T WhoCmd = {
    "who", 
    "Shows who is logged on, or 'who id' for specifics", 
    Who, 
    visible
};
 
RUNRESULT_T SignOnBanner(char *p);
const CMD_T SignOnBannerCmd = {
    "About", 
    "About this program", 
    SignOnBanner, 
    invisible
};
 
RUNRESULT_T SignOnBanner(char *p)
{
    puts("\r\nThis program was built " __DATE__ " " __TIME__ ".\r\n");
    return runok;
}
 
RUNRESULT_T Who(char *p) {
    printf("\r\nwho...\r\n");
    if (*p)
        printf(" Sorry, no help for [%s]\r\n", p);
    return runok;
}

RUNRESULT_T Send(char *p) {
    printf("\r\nSending bytes...\r\n");
    if (*p)
        {
            red = 0;
            printf("[%s]\r\n", p);
            cmd[0] = p[0];
            cmd[1] = p[1];
            i2c.write(addr, cmd, 2);
            red = 1;
        }
        
    return runok;
}
RUNRESULT_T Read(char *p) {
    printf("\r\nRead...\r\n");
    if (*p)
        {
            green=0;
            Send(p);
            i2c.read(addr, cmd, 2);
            float tmp = (float((cmd[0]<<8)|cmd[1]) / 256.0);
            printf("Temp = %.2f\n", tmp);
            green=1;
        }
    return runok;
} 
// Provide the serial interface methods for the command processor
#ifdef WIN32
int mReadable() { return _kbhit(); }
int mGetCh() { return _getch(); }
int mPutCh(int a) { return _putch(a); }
int mPutS(const char * s) { return printf("%s\r\n", s); }
#else
Serial pc(USBTX, USBRX);
int mReadable() { return pc.readable(); }
int mGetCh() { return pc.getc(); }
int mPutCh(int a) { return pc.putc(a); }
int mPutS(const char * s) { return pc.printf("%s\r\n", s); }
#endif
 
int main(int argc, char* argv[])
{
    CMDP_T * cp = GetCommandProcessor();
#ifdef WIN32
    // nothing special for Win32
#else
    pc.baud(921600);
#endif
    cp->Init(
        &SignOnBannerCmd,
        CFG_ENABLE_TERMINATE | CFG_ENABLE_SYSTEM 
        | CFG_ECHO_ON | CFG_CASE_INSENSITIVE,   // options
        50,         // Command Buffer length 
        5,          // History depth # of commands
        mReadable,  // User provided API (kbhit())
        mGetCh,     // User provided API
        mPutCh,     // User provided API
        mPutS);     // User provided API
 
    // Start adding custom commands now
    cp->Add(&WhoCmd);
    cp->Add(&SendCmd);
    cp->Add(&ReadCmd);
 
    //alive signal
    red = 1;
    green=1;
    blue=1;
    flipper.attach(&flip, 0.5);
 
    // Should never "wait" in here
    while (cp->Run() == runok)  // run this timeslice
    {
       
    }
    cp->End();  // cleanup
    return 0;
}