//#include "mbed.h"
#include "rtos.h"

#define UN_HUITIEME_SHORT 0x1FFF
#define MOVING_AVG_SIZE 5

struct message_t
{
    time_t timestamp;
    char pin_id;
    unsigned short value;
};

struct MovingAverage_t
{
    unsigned short buffer[MOVING_AVG_SIZE];
    char cursor;
    bool bFilled;
};

Thread* t1;
Thread* t2;
Thread* t3;

DigitalIn* en_1;
DigitalIn* en_2;
AnalogIn* ea_1;
AnalogIn* ea_2;
Mutex* mutex;
Mail<message_t, 16>* Mailbox;

MovingAverage_t* MovingAverageP19;
MovingAverage_t* MovingAverageP20;

bool bLast_p15 = false;
bool bLast_p16 = false;
unsigned short u16Last_p19 = 0;
unsigned short u16Last_p20 = 0;

unsigned char currentTimer = 0;
void ISR_RTC()
{
    currentTimer++;
    
    switch (currentTimer)
    {
        case 2:
        case 4:
        case 6:
        case 8:
        {
            t2->signal_set(1);
            break;
        }
        case 5:
        {
            t1->signal_set(1);
            break;
        }
        case 10:
            t2->signal_set(1);
            t1->signal_set(1);
            currentTimer = 0;
            break;
    }
    t2->signal_set(2);
}

unsigned short moyenne_mobile(MovingAverage_t* MA, unsigned short newData)
{
    int sum = 0;
    MA->buffer[MA->cursor] = newData;
    MA->cursor++;
    if (MA->cursor >= MOVING_AVG_SIZE)
    {
        MA->cursor = 0;
        MA->bFilled = true;
    }
    
    if (MA->bFilled)
    {
        for (char i = 0; i < MOVING_AVG_SIZE; i++)
        {
            sum += MA->buffer[i];
        }
        sum = sum / MOVING_AVG_SIZE;
    }
    else
    {
        for (char i = 0; i < MA->cursor; i++)
        {
            sum += MA->buffer[i];
        }
        sum = sum / MA->cursor;
    }
    
    return sum;
}

void MailBox_put(time_t timestamp, char pin_id, unsigned short value)
{
    // Prepare the message to send
    message_t* msg = Mailbox->calloc();
    msg->timestamp = timestamp;
    msg->pin_id = pin_id;
    msg->value = value;
    
    // Add the message to the mailbox
    mutex->lock();
    Mailbox->put(msg);
    mutex->unlock();
}

void lecture_analog() {
    while (true) {
        // synchronisation sur la période d'échantillonnage
        t1->signal_clr(1);
        t1->signal_wait(1);
        
        // lecture de l'étampe temporelle
        time_t curTime = time(NULL);
        
        // lecture des échantillons analogiques
        // calcul de la nouvelle moyenne courante
        unsigned short res_p19 = moyenne_mobile(MovingAverageP19, ea_1->read_u16());
        unsigned short res_p20 = moyenne_mobile(MovingAverageP20, ea_2->read_u16());
        
        // génération éventuelle d'un événement
        if ((res_p19 + UN_HUITIEME_SHORT) < u16Last_p19 || (res_p19 - UN_HUITIEME_SHORT) > u16Last_p19 )
        {
            MailBox_put(curTime, 19, res_p19);
        }
        if ((res_p20 + UN_HUITIEME_SHORT < u16Last_p20) || (res_p20 - UN_HUITIEME_SHORT) > u16Last_p20 )
        {
            MailBox_put(curTime, 20, res_p20);
        }
        
        u16Last_p19 = res_p19;
        u16Last_p20 = res_p20;
    }
}
void lecture_num() {
    while (true) {
        // synchronisation sur la période d'échantillonnage
        t2->signal_clr(1);
        t2->signal_wait(1);
        
        // lecture de l'étampe temporelle
        time_t curTime = time(NULL);
        
        // lecture des échantillons numériques
        bool bP15 = en_1->read();
        bool bP16 = en_2->read();
        
        // prise en charge du phénomène de rebond
        t2->signal_clr(2);
        t2->signal_wait(2); // :')
        
        // génération éventuelle d'un événement
        if (en_1->read() == bP15 && bP15 != bLast_p15)
        {
            MailBox_put(curTime, 15, bP15);
            bLast_p15 = bP15;
        }
        if (en_2->read() == bP16 && bP16 != bLast_p16)
        {
            MailBox_put(curTime, 16, bP16);
            bLast_p16 = bP16;
        }
    }
}

void collection()
{
    while(true)
    {
        // attente et lecture d'un événement
        osEvent Mail = Mailbox->get();
        if (Mail.status == osEventMail)
        {
            message_t* msg = (message_t*)Mail.value.p;
            
            // écriture de l'événement en sortie (port série)
            printf("%s  - Evenement de la pin %d avec valeur %d\n\n", ctime(&(msg->timestamp)), msg->pin_id, msg->value);
 
            Mailbox->free(msg);
        }
    }
}

int main() {
    // Initialization de tous les globals
    Mailbox = new Mail<message_t, 16>();
    MovingAverageP19 = new MovingAverage_t();
    MovingAverageP20 = new MovingAverage_t();
    en_1 = new DigitalIn(p15);
    en_2 = new DigitalIn(p16);
    ea_1 = new AnalogIn(p19);
    ea_2 = new AnalogIn(p20);
    mutex = new Mutex();
    
    // set the time
    set_time(1485887400 - 18000); // -18000 car GMT -5, hardcodé pour 31 janvier 13h30
    
    // démarrage des tâches
    t1 = new Thread();
    t2 = new Thread();
    t3 = new Thread();
    
    t1->start(lecture_analog);
    t2->start(lecture_num);
    t3->start(collection);
    
    Ticker tick;
    
    tick.attach(&ISR_RTC, 0.05); // tick aux 50ms
    
    while(true) {
    }
}