#include "xbee.h"
#include "Accelerometer.h"
#include "IO_p15.h"
#include "config.h"

//#define __DEBUG__
#ifdef __DEBUG__
Serial pc(USBTX, USBRX, 9600);
#endif
PwmOut led1(LED1);
//--------------------------------------------------------------//
// APP stuff : tableau de pointeur de fonctions
//--------------------------------------------------------------//
#define NB_FUNCTIONS 2
void func_accel(CArray*);
void func_button(CArray*);
void (*functions[NB_FUNCTIONS])(CArray*) = {func_accel, func_button};
//--------------------------------------------------------------//

int main() {
    DigitalOut RESET(p8);
    Serial XBee(p13, p14, 9600);
    
    // Selon le lab, reset le Xbee
    RESET = 0;
    wait_ms(400);
    RESET = 1;

#ifdef __DEBUG__
    pc.format(8, SerialBase::None, 1);
#endif
    XBee.format(8, SerialBase::None, 1);
    
    CArray DATA_TO_SEND;
    
    // Addresse spéciale pour le coordinateur
    for (int j = 0; j < 8; j++)
        DATA_TO_SEND._64bit.bit[j] = 0;
    DATA_TO_SEND._16bit.bit[0] = 0xFF;
    DATA_TO_SEND._16bit.bit[1] = 0xFE;
    
    DATA_TO_SEND._FrameType = 0x10; // Transmit Request    
    
    // options pour l'envoie au coordinateur
    DATA_TO_SEND.options = new char[2];
    DATA_TO_SEND.options[0] = 0; // broadcast
    DATA_TO_SEND.options[1] = 0; // other options
    DATA_TO_SEND.opt_size = 2;
    
    bool IsInitialized = false;
    char InitBytes = 0;
    
    while(1)
    {
        if (IsInitialized)
        {
            for (char i = 0; i < NB_FUNCTIONS; i++)
            {
                DATA_TO_SEND._ptr = NULL;
                
                (*functions[i])(&DATA_TO_SEND);
                
                if (DATA_TO_SEND._ptr != NULL)
                {
                    led1 = !led1;
                    send(&XBee, &DATA_TO_SEND);
#ifdef __DEBUG__
                    send(&pc, &DATA_TO_SEND); // debug only
#endif
                    delete DATA_TO_SEND._ptr;
                }
            }
            wait_ms( 1000 / SENSOR_FREQUENCY_HZ);
        }
        if (XBee.readable())
        {
#ifdef __DEBUG__
            pc.putc(XBee.getc());
#endif
            InitBytes++;
            if (InitBytes == 6)
            {
                IsInitialized = true;
                setPAN(&XBee, PAN_ID);
#ifdef __DEBUG__
                setPAN(&pc, PAN_ID);
#endif
            }
        }
        
#ifdef __DEBUG__
        if (pc.readable())
        {
            XBee.putc(pc.getc());
        }
#endif
    }
}