#include "xbee.h"
#include "config.h"
#include "EthernetInterface.h"
#include "Websocket.h"

//#define __DEBUG__
//#ifdef __DEBUG__
Serial pc(USBTX, USBRX, 9600);
//#endif
PwmOut led1(LED1);
PwmOut led4(LED4);

int main() {
    
    // Setup du port ethernet
    EthernetInterface eth;
    eth.init(mbedIp, mbedMask, mbedGateway);
    eth.connect();
    
    DigitalOut RESET(p8);
    Serial XBee(p13, p14, 9600);
    
    // Selon le lab, reset le Xbee
    RESET = 0;
    wait_ms(400);
    RESET = 1;

#ifdef __DEBUG__
    pc.format(8, SerialBase::None, 1);
#endif
    XBee.format(8, SerialBase::None, 1);
    
    CArray DATA_TO_READ;
    
    bool IsInitialized = false;
    bool bAddressSet = false;
    char InitBytes = 0;
    
    Websocket ws(WEBSOCKET_URL);
    ws.connect();
    wait(1);
    
    while(1)
    {
#ifdef __DEBUG__
        if (pc.readable())
        {
            XBee.putc(pc.getc());
        }
#endif
    
        if (IsInitialized)
        {
            DATA_TO_READ._ptr = NULL;
#ifdef __DEBUG__
            if (XBee.readable())
            {
                pc.putc(XBee.getc());
            }
#endif
            read(&XBee, &DATA_TO_READ);

            if (DATA_TO_READ._ptr != NULL)
            {
                led1 = !led1;
                
                if (!bAddressSet)
                {
                    bAddressSet = true;

                    CArray DATA_TO_SEND;
                    
                    DATA_TO_SEND._64bit = DATA_TO_READ._64bit; // <-- Je récupère l'addresse au premier paquet. Inutile de faire plus pour l'app ...
                    DATA_TO_SEND._16bit = DATA_TO_READ._16bit;
                    
                    DATA_TO_SEND._FrameType = 0x17; // Remote AT Request
                    
                    // options pour l'envoie au coordinateur
                    DATA_TO_SEND.options = new char[1];
                    DATA_TO_SEND.options[0] = 0x02;
                    DATA_TO_SEND.opt_size = 1;
                    
                    DATA_TO_SEND._ptr = new char[3];
                    DATA_TO_SEND._ptr[0] = 'L';
                    DATA_TO_SEND._ptr[1] = 'T';
                    DATA_TO_SEND._ptr[2] = 100; // x10ms donc 1000ms donc 1hz
                    DATA_TO_SEND.size = 3;
                    
                    send(&XBee, &DATA_TO_SEND);
#ifdef __DEBUG__
                    send(&pc, &DATA_TO_SEND);
#endif
                    
                    delete DATA_TO_SEND._ptr;
                    delete DATA_TO_SEND.options;
                }
                
#ifdef __DEBUG__
                for (int i = 0; i < DATA_TO_READ.size; i++)
                {
                    pc.putc(DATA_TO_READ._ptr[i]); // debug ; send to pc
                }
#endif
                ws.send(DATA_TO_READ._ptr);
                wait_ms(5);
                char* result;
                ws.read(result);
                
                pc.printf(result);
                
                delete DATA_TO_READ._ptr;
            }
        }
        else if (XBee.readable())
        {
#ifdef __DEBUG__
            pc.putc(XBee.getc());
#endif
            InitBytes++;
            if (InitBytes == 6)
            {
                IsInitialized = true;
            }
        }
    }
}