/* SpwfInterface NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "SpwfInterface.h"
#include "TCPSocket.h"



//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

SpwfSAInterface spwf(D8, D2, false);
TCPSocket socket;

int main() { 
    char* ssid = "fablab_guest";
    char* seckey = "veronafablab";
    
    pc.printf("\r\nX-NUCLEO-IDW01M1 mbed Application\r\n");     
    pc.printf("\r\nconnecting to AP\r\n");
    
    if(spwf.connect(ssid, seckey, NSAPI_SECURITY_WPA2)) {      
        pc.printf("\r\nnow connected\r\n");
    } else {
        pc.printf("\r\nerror connecting to AP.\r\n");
        return -1;
    }   
 
    const char *ip = spwf.get_ip_address();
    const char *mac = spwf.get_mac_address();
    
    pc.printf("\r\nIP Address is: %s\r\n", (ip) ? ip : "No IP");
    pc.printf("MAC Address is: %s\r\n", (mac) ? mac : "No MAC"); 
       
 
    socket.open(&spwf);
    socket.connect("fabio.infosistem.it", 80);
    char url[] = "http://fabio.infosistem.it/post.php";
    char host[] = "fabio.infosistem.it";
    char path[] = "/post.php";
    char meth[] = "POST"; //http method ('POST', 'GET', 'PUT', 'DELETE')
    //char key[] = "Hello";
    //char value[] = "World";
    // Body of the message 
    char data[] = "Hello=World";
    //snprintf(data, sizeof(data), "%s=%s", key, value);
    printf("\r\n%s\r\n", data);
    char type[] = "Content-Type: application/x-www-form-urlencoded";
    char length[32];
    snprintf(length, sizeof(length), "Content-Length: %s", sizeof(data));
    // Send a simple http request
    char sbuffer[256];
    snprintf(sbuffer,sizeof(sbuffer),"%s %s HTTP/1.1\r\n\%s\r\nHost: %s\r\n%s\r\n\r\n%s\r\n", meth, path, type, host, length, data);
    int scount = socket.send(sbuffer, sizeof sbuffer);
    printf("sent %d\r\n%s", scount, sbuffer);

    // Recieve a simple http response and print out the response line
    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("recv %d [%.*s]\r\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);

    // Close the socket to return its memory and bring down the network interface
    socket.close();
    spwf.disconnect();

    printf("Done\n");
    
    while(1) { 
        wait(1);
        myled = !myled;
    }
}
