#include "mbed.h"
#include "EthernetNetIf.h"
EthernetNetIf eth;

void dogKick() {
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
    printf("dogkick\n");
}
void setDog(float s =30) {
    LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
    LPC_WDT->WDTC = s * (float)clk;
    LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
    dogKick();
}
DigitalOut ethrst(P1_28);// PHY chip on mbed reset
DigitalOut led(LED3); //Alive
int main() {
    ethrst=0;//PHY reset
    wait(1);
    ethrst=1;
    wait(1);
    
    printf("\n\nStartup...\n");
   
    
    setDog(30);
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();// i have tested with different timeouts setup(30000) etc


    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
    led=1;
    return 0;

}