/* LEDout.h */
#ifndef LEDOUT_H
#define LEDOUT_H
#include "mbed.h"

/**Library to show error code with MBED leds.
@file LEDout.h
@code
#include "mbed.h"
#include "LEDout.h"
int main()
{
    LEDout led;
    led.blink(15,20);//Blink code 15, 20times, //noblocking, so code can continue
    for(int k=0; k<10; k++){
        printf("printing while blinking ;) \n");
        wait(1);
    }
    wait(2);
    led.blinks(1,3);//blocking, code 1, 3 blinks, code will not continue  until blinks done
    led.blinkSet(2,3);//blocking, code stops here, blinks will continue blinking
    return 0;
}
@endcode
*/


/** Library to show error code with MBED leds.
*
*/
class LEDout : public BusOut
{
    public:
    /** Create a LEDout object
    */

    LEDout():BusOut(LED1,LED2,LED3,LED4) {
        _cmd=0;
        _dur=0;
        _blankwait=2; //sec
        //  printf("Ledout init\n");
    }
    /** Non-blocking process blink
    *  @param cmd 1-15
    *  @param cnt how many times to blink
    *  @param dur blink interval default 0.2sec
    */
   
    void blink(int cmd,int cnt, float dur=0.2) {// parallel process
        _cmd=0;
        _dur=0;
        _cmd=cmd;
        _dur=dur*1000*1000;
        _blinkcnt=0;//reset
        _blinkamount=cnt*2;//on/off
        //  printf("Blink start cmd %d dur %f blinkcnt %d amount %d cnt %d\n",_cmd,_dur,_blinkcnt,_blinkamount, cnt);
        _ticker2.attach_us(this,&LEDout::blinktick,_dur);
        //   printf("Blink start cmd %d dur %f blinkcnt %d amount %d cnt %d\n",_cmd,_dur,_blinkcnt,_blinkamount, cnt);


    }
    /** Blocking process blink
    *  @param cmd 1-15
    *  @param cnt how many times to blink
    *  @param dur blink interval default 0.2sec
    */
    void blinks(int cmd,int cnt, float dur =0.2) {// blocking
        for (int k=1; k<=cnt; k++) {
            LEDout::write(cmd);//ON
            wait(dur);
            LEDout::write(0);//OFF
            wait(dur);
        }
    }
    /** Blocking process and end with loop
    *  @param cmd 1-15
    *  @param cnt how many times to blink
    *  @param dur blink interval default 0.2sec
    */
    void blinkSet(int cmd,int cnt, float dur =0.2) {// blocking and stopping

        while (1) {
            blinks( cmd, cnt,  dur);
            wait(_blankwait); // blank space
        }
    }
protected:
    Timeout _timeout;
    Ticker _ticker2;
    int _blinkcnt;
    int _blinkamount;
    int _cmd; // bit command
    float _blankwait;
    float _dur;


    void blinktick(void) {// ticker function

        // printf("blink\n");
        if (LEDout::read()==_cmd)//command
            LEDout::write(0);
        else
            LEDout::write(_cmd);

        _blinkcnt++;

        if (_blinkamount==NULL or !_blinkamount)return;

        if (_blinkcnt==_blinkamount) {
            _ticker2.detach();
            return;
        }
    }
};
#endif/* LEDOUT_H */
