
#ifndef MS4525DO_H
#define MS4525DO_H

#include "mbed.h"

#define I2C_ADDRESS_MS4525DO    0x28    /**< 7-bit address =0x28. 8-bit is 0x50. Depends on the order code (this is for code "I") */

/* Register address */
#define ADDR_READ_MR            0x00    /* write to this address to start conversion */

// MS4525D sensor full scale range and units
const int16_t MS4525FullScaleRange = 1;  // 1 psi

// MS4525D Sensor type (A or B) comment out the wrong type assignments
// Type A (10% to 90%)
const int16_t MS4525MinScaleCounts = 1638;
const int16_t MS4525FullScaleCounts = 14746;

const int16_t MS4525Span=MS4525FullScaleCounts-MS4525MinScaleCounts;

//MS4525D sensor pressure style, differential or otherwise. Comment out the wrong one.
//Differential
const int16_t MS4525ZeroCounts=(MS4525MinScaleCounts+MS4525FullScaleCounts)/2;


class MS4525DO
{
    public:
    // instance methods
        // explicit I2C pin names
        MS4525DO(PinName sda, PinName sck, char slave_adr = I2C_ADDRESS_MS4525DO);
        
        // pin names as an object (ideal when sharing the bus)
        MS4525DO(I2C &i2c_obj, char slave_adr = I2C_ADDRESS_MS4525DO);
    
        virtual ~MS4525DO();
    
    // public functions
        void initialize(void);
        int measure(void);              // returns status of measurement
        float getPSI(void);             // returns the PSI of last measurement
        float getTemperature(void);     // returns temperature of last measurement
        float getAirSpeed(void);        // calculates and returns the airspeed
        int calibrate(void);            // attempts to calibrate and returns a status code
         
    
    private:
        I2C         *i2c_p;
        I2C         &i2c;
        char        address;
        char        _status;
        float       psi;
        float       temperature;
        float       airspeed;
        uint16_t    P_dat;  // 14 bit pressure data
        uint16_t    T_dat;  // 11 bit temperature data
        
    // private functions
        int collect(void);
        char fetch_pressure(uint16_t &P_dat, uint16_t &T_dat);
          
    
};  // end of the class


/** airspeed scaling factors; out = (in * Vscale) + offset */
struct airspeed_scale {
    float   offset_pa;
    float   scale;
};

#endif 
