/*
 * Author: Edoardo De Marchi
 * Date: 22-08-14
 * Notes: Firmware for GPS U-Blox NEO-6M
 *
 * Modified: Emery Premeaux
 * Date: July 2019
 * Written for: Nucleo F401RE & NEO-M8N
 *
 * Updated MODSERIAL library now compiles without errors but data seems corrupted.
 *
 * NMEA sentences:  https://www.gpsinformation.org/dale/nmea.htm#nmea
 * 
*/

#include "mbed.h"
//#include "MODSERIAL.h"

//MODSERIAL pc(USBTX,USBRX);
//MODSERIAL gps(D8, D2);

Serial pc(USBTX,USBRX);
Serial gps(D8, D2);

char cDataBuffer[500];
int i = 0;
int h_time,m_time,s_time;

void Init();
void parse(char *cmd, int n);
void parseTime (float timeval);


void Init()
{
    gps.baud(115200);
     pc.baud(115200);
    pc.printf("Init OK\n");
}



int main() 
{   
    Init();
    char c;

    while(true) 
    {
        if(gps.readable())
        { 
            if(gps.getc() == '$');           // wait a $
            {
                for(int i=0; i<sizeof(cDataBuffer); i++)
                {
                    c = gps.getc();
                    if( c == '\r' )
                    {
                        //pc.printf("%s\n", cDataBuffer);
                        parse(cDataBuffer, i);
                        i = sizeof(cDataBuffer);
                    }
                    else
                    {
                        cDataBuffer[i] = c;
                    }                 
                }
            }
         } 
    }
}

/* 
 * NMEA sentences:  https://www.gpsinformation.org/dale/nmea.htm#nmea
 *                  http://navspark.mybigcommerce.com/content/NMEA_Format_v0.1.pdf
 */
void parse(char *cmd, int n)
{   
    char ns, ew, tf, status;
    int fq, nst, fix, date;                                     // fix quality, Number of satellites being tracked, 3D fix
    float latitude, longitude, timefix, speed, altitude;
    
    // Global Positioning System Fix Data
    if(strncmp(cmd,"$GPGGA", 6) == 0) 
    {
        sscanf(cmd, "$GPGGA,%f,%f,%c,%f,%c,%d,%d,%*f,%f", &timefix, &latitude, &ns, &longitude, &ew, &fq, &nst, &altitude);
        pc.printf("GPGGA Fix taken at: %f, Latitude: %f %c, Longitude: %f %c, Fix quality: %d, Number of sat: %d, Altitude: %f M\n", timefix, latitude, ns, longitude, ew, fq, nst, altitude);
    }
    
    // Satellite status
     else if(strncmp(cmd,"$GPGSA", 6) == 0) 
    {
        sscanf(cmd, "$GPGSA,%c,%d,%d", &tf, &fix, &nst);
        pc.printf("GPGSA Type fix: %c, 3D fix: %d, number of sat: %d\r\n", tf, fix, nst);
    }
    
    // Geographic position, Latitude and Longitude
    else if(strncmp(cmd,"$GPGLL", 6) == 0) 
    {
        sscanf(cmd, "$GPGLL,%f,%c,%f,%c,%f", &latitude, &ns, &longitude, &ew, &timefix);
        pc.printf("GPGLL Latitude: %f %c, Longitude: %f %c, Fix taken at: %f\n", latitude, ns, longitude, ew, timefix);
    }
    
    // Geographic position, Latitude and Longitude
    else if(strncmp(cmd,"$GPRMC", 6) == 0) 
    {
        sscanf(cmd, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &timefix, &status, &latitude, &ns, &longitude, &ew, &speed, &date);
        pc.printf("GPRMC Fix taken at: %f, Status: %c, Latitude: %f %c, Longitude: %f %c, Speed: %f, Date: %d\n", timefix, status, latitude, ns, longitude, ew, speed, date);
    }
    
    // 
    else if(strncmp(cmd,"$GNVTG", 6) == 0) 
    {
     //   pc.printf("its a Vector Track message.\n");
    }
    
    else if(strncmp(cmd,"$GNGGA", 6) == 0) 
    {
        sscanf(cmd, "$GNGGA,%f,%f,%c,%f,%c,%d,%d,%*f,%f", &timefix, &latitude, &ns, &longitude, &ew, &fq, &nst, &altitude);
        pc.printf("GNGGA Fix taken at: %f, Latitude: %f %c, Longitude: %f %c, Fix quality: %d, Number of sat: %d, Altitude: %f M\n", timefix, latitude, ns, longitude, ew, fq, nst, altitude);
        parseTime(timefix);
        pc.printf("Time: %d:%d:%d\n", h_time, m_time, s_time);
    }
    
    else if(strncmp(cmd,"$GNGSA", 6) == 0) 
    {
        sscanf(cmd, "$GNGSA,%c,%d,%d", &tf, &fix, &nst);
        pc.printf("GNGSA Type fix: %c, 3D fix: %d, number of sat: %d\r\n", tf, fix, nst);
    }
    
    else if(strncmp(cmd,"$GPGSV", 6) == 0) 
    {
     //   pc.printf("its a Satellite details message.\n");
    }
    
    else if(strncmp(cmd,"$GNGLL", 6) == 0) 
    {
        sscanf(cmd, "$GNGLL,%f,%c,%f,%c,%f", &latitude, &ns, &longitude, &ew, &timefix);
        pc.printf("GNGLL Latitude: %f %c, Longitude: %f %c, Fix taken at: %f\n", latitude, ns, longitude, ew, timefix);
    }
    
    else
    {
   //     pc.printf("Unknown message type\n");
    }
}

void parseTime (float timeval)
{
    //format utc time to beijing time,add 8 time zone
                float time = timeval + 80000.00f;
                h_time = int(time) / 10000;
                m_time = (int(time) % 10000) / 100;
                s_time = int(time) % 100;
}



