/*
 * Opens index.txt, reads a number from the file (as charactor binary value)
 * Closes that file, then creates a file name string by adding one to the index number
 * Creates and opens a new file with the file name string, and writes some text before closing.
 *
 */ 


#ifdef COMPILE_SD_Index_File

#include "SDFileSystem.h"

SDFileSystem sd(PB_5, PB_4, PB_3, PA_11, "sd");     // MOSI, MISO SCLK, CS, "name"

int last_file_num;


int main() {
    FILE *IndexFile = fopen("/sd/index.txt", "r"); // get the last file number from the index file
    last_file_num = fgetc(IndexFile);
    printf("Got: %i \n", last_file_num);
    fclose(IndexFile);
    last_file_num++;
    IndexFile = fopen("/sd/index.txt", "w"); // wrte the new number into the index file
    fputc(last_file_num, IndexFile);
    fclose(IndexFile);
    
    char filename[12];
    sprintf(filename, "/sd/%i.txt", last_file_num);   // build new filename to open

    FILE *File = fopen(filename, "w");
    if(File == NULL) {
        printf("Could not open file to write\n");
    }
    else {
        printf("SD card file opened: %s\n", filename);
        fprintf(File, "heres some data!");
        fclose(File);
        printf("closed\n");
    }
}

#endif
            