#ifdef COMPILE_ADC_Internal  

/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/

AnalogIn adc_temp(ADC_TEMP);
AnalogIn adc_vref(ADC_VREF);
AnalogIn adc_vbat(ADC_VBAT); // Warning: Not available on all devices

DigitalOut led(LED1);

int main()
{
    printf("\nSTM32 ADC internal channels reading example\n");
    while(1) {
        printf("ADC Temp = %f\n", adc_temp.read());
        printf("ADC VRef = %f\n", adc_vref.read());
        printf("ADC VBat = %f\n", adc_vbat.read());
        printf("\033[3A");
        led = !led;
        wait(1.0);
    }
}

#endif
