//#include "EthernetInterface.h"
#include <stdlib.h>
#include <string.h>
#include "mbed.h"
#include "rtos.h" // need for main thread sleep
#include "html.h" // need for html patch working with web server
#include "bloc_io.h"
#define RADIUS  0.2F // wheel size
#define NBPOLES 8 // magnetic pole number
#define DELTA_T 0.1 // speed measurement counting period
#define Nvmax 0.388034
#define Nvmin 0.258689
#define Vbatmax 30
#define P_velo 9
#define Ray 0.2
#define delta_t 0.2
#define pi 3.14159265358979

Bloc_IO MyPLD(p25,p26,p5,p6,p7,p8,p9,p10,p23,p24);// instantiate object needed to communicate with PLD
// analog input connected to mbed
// valid pmw mbed pin
Serial pc(USBTX, USBRX); // tx, rx
// Top_Hall Pin
InterruptIn Top_Hall(p22);
AnalogIn Vbat(p18);
AnalogIn Vtemp(p19);
AnalogIn Vgaz(p17);
DigitalOut Valid_PWM(p21);

/************ persistent file parameters section *****************/
LocalFileSystem local("local");               // Create the local filesystem under the name "local"








/********************* web server section **********************************/

var_field_t tab_balise[10];  //une balise est présente dans le squelette
int giCounter=0;// acces counting


/*********************** can bus section  ************/
// determine message ID used to send Gaz ref over can bus
#define _CAN_DEBUG // used to debug can bus activity
//#define USE_CAN_REF // uncomment to receive gaz ref over can_bus
CAN can_port (p30, p29); // initialisation du Bus CAN sur les broches 30 (rd) et 29(td) for lpc1768 + mbed shield
bool bCan_Active=false;



DigitalOut led1(LED1); //initialisation des Leds présentes sur le micro-controleur Mbed*/
DigitalOut led2(LED2);
DigitalOut led3(LED3); // blink when can message is sent
DigitalOut led4(LED4); // blink when can message is received
float gfNMAX=0.71 ,gfNMIN=0.16;
float gfNmax ,gfNmin;
float gfNGAZ;
float gNTemp, gTemp;
float gfNVbat,gfVbat;
int giPoignee;
float gfPoignee;
int gicpt_Valid_Hall;
float gfcpt_Hall, gfVitmesure;
Ticker TGaz,TickDeltaT, TickMod;




//************ local function prototypes *******************

void Sauvegarde(void);
void Lecture(void);
void PoigneeGaz(void);
void CalculTemp (void);
void CalculVbat (void);
void MesVit(void);
void Incr_Valid_Hall(void);

/**************** Read persistent data from text file located on local file system ****************/



/**************** write persitant  data to text file located on local file system ****************/






//************** calibation gaz function needed to record min_gaz and max_gaz value to persistent text file  ******************


// ************top hall counting interrupt needed for speed measurement


//********************** timer interrupt for speed measurement each 100ms  *************************






//********************* Timer Interrupt for gaz ref management each 10ms   ********************



/********* main cgi function used to patch data to the web server thread **********************************/
void CGI_Function(void) // cgi function that patch web data to empty web page
{
    char ma_chaine4[20]= {}; // needed to form html response

}


/*********************** CAN BUS SECTION  **********************/




void CAN_REC_THREAD(void const *args)
{
    int iCount,iError;

    while (bCan_Active) {
        Thread::wait(100);// wait 100ms
        // code todo

    }

}



//*************************** main function *****************************************
int main()
{
    char cChoix=0;
    char cCalibration=0;
    Top_Hall.mode(PullUp);
    Top_Hall.rise(&Incr_Valid_Hall);
    TGaz.attach(&PoigneeGaz,0.1);
    TickDeltaT.attach(&MesVit,delta_t);
    Valid_PWM.write(1);
    
//***************************************** web section ********************************************/
//Init_Web_Server(&CGI_Function); // create and initialize tcp server socket and pass function pointer to local CGI function
//Thread WebThread(Web_Server_Thread);// create and launch web server thread
    /********* main cgi function used to patch data to the web server thread **********************************/

//******************************************* end web section  ************************************* /




    pc.printf(" programme scooter mbed \r\n");



//********************* can bus section initialisation *******************************************
//bCan_Active=true;// needed to lauchn CAN thread
//Thread CanThread(CAN_REC_THREAD);// create and launch can receiver  thread
//********************* end can bus section *****************************************************


    while(cChoix!='q' and cChoix!='Q') {
        pc.printf(" veuillez saisir un choix parmi la liste proposee: \r\n");
        pc.printf(" a:saisie consigne pwm \r\n");
        pc.printf(" b:lecture poignee \r\n");
        pc.printf(" f:Affichage informations batterie \r\n");
        pc.printf(" c:calibration de la poignee \r\n");
        pc.printf(" d:Affichage vitesse \r\n");
        pc.printf(" q:quitter \r\n");

        /************* multithreading : main thread need to sleep in order to allow web response */
        while (pc.readable()==0) { // determine if char availabler
            Thread::wait(10);   // wait 10 until char available on serial input
        }

        /************* end of main thread sleep  ****************/

        pc.scanf(" %c",&cChoix);
        switch (cChoix) {
            case 'a':
                
                break;
                
            case 'b':
                while(Vgaz.read()<=0.700)
                {
                pc.printf("Val poignee=%0.3f \r\n",Vgaz.read());
                pc.printf("Nmax=%0.3f \r\n",gfNMAX);
                pc.printf("PLD=%i \r\n",giPoignee);
                wait(0.1);
                }
                break;
            case 'c':
                Valid_PWM.write(0);
                while(cCalibration!='4') {
                    pc.printf("1:Calibrer le max de la poignee et mettre la poignee au maximum \r\n");
                    pc.printf("2:Calibrer le min de la poignee et mettre la poignee au minimum \r\n");
                    pc.printf("3:Affichage des valeurs dans le fichier \r\n");
                    pc.printf("4:Retour au menu principal \r\n");
                    pc.scanf("%c", &cCalibration);
                    switch(cCalibration) {
                        case '1':
                            gfNMAX=Vgaz.read();
                            pc.printf("la valeur max de la poignee est: %0.3f\r\n",gfNMAX);
                            Sauvegarde();
                            break;

                        case '2':
                            gfNMIN=Vgaz.read();
                            pc.printf("la valeur min de la poignee est: %0.3f\r\n",gfNMIN);
                            Sauvegarde();
                            break;

                        case '3':
                            Lecture();
                            break;

                        case'4' :
                            break;
                    }
                }
                Valid_PWM.write(1);
                cCalibration=0;
                cChoix=0;
                break;
            
            case 'f':
                CalculTemp ();
                CalculVbat ();
                pc.printf(" La tension de la batterie est %f \r\n",gfVbat);
                pc.printf(" La temperature est de %f \r\n",gTemp);
                break;
            
            case 'd':
                pc.printf(" La vitesse de est de %f \r\n",gfVitmesure);
                break;
                
            case 'q':
                break;
        }
    } // end while

    //************** thread deinit *********************
    //DeInit_Web_Server();
    //bCan_Active=false;
    //CanThread=false;// close can received thread
    pc.printf(" fin programme scooter mbed \r\n");
} // end main

void PoigneeGaz()
{
    gfNGAZ=Vgaz.read();
    gfNmin=gfNMIN;
    gfNmax=gfNMAX;
    giPoignee=(gfNGAZ-gfNmin)*(255/(gfNmax-gfNmin));
    int iVal=MyPLD.read();
    MyPLD.write(giPoignee);
}
    
void Lecture ()
{
    FILE* File1 = fopen("/local/CALIB.txt","r");
    if (File1 == NULL) {
        pc.printf("Erreur\r\n");
    } else {
        fscanf(File1, "%f %f",&gfNMIN,&gfNMAX);
        pc.printf("NMIN= %f \r\n",gfNMIN);
        pc.printf("NMAX= %f \r\n",gfNMAX);
    }
    fclose(File1);
}


void Sauvegarde ()
{
    FILE* File1 = fopen("/local/CALIB.txt","w");
    if(File1 == NULL) {
        pc.printf("Erreur\r\n");
    } else {
        fprintf(File1, "%f %f",gfNMIN,gfNMAX);
        pc.printf("Sauvegarde ok min et max \r\n");
    }
    fclose(File1);
}

void CalculTemp()
{
    gNTemp=Vtemp.read()*3.3;
    gTemp=gNTemp*100-275;
}

void CalculVbat()
{
    gfNVbat=Vbat.read();
    gfVbat=(gfNVbat*Vbatmax/Nvmax);
}

void Incr_Valid_Hall()
{
    gicpt_Valid_Hall++;
}


void MesVit()
{
    gfcpt_Hall=gicpt_Valid_Hall;
    gicpt_Valid_Hall=0;
    gfVitmesure= (gfcpt_Hall*2*pi*Ray)/(delta_t*6*P_velo); 
} 

