#include "mbed.h"
 
//****************************************************************************** Define
//The number will be compiled as type "double" in default
//Add a "f" after the number can make it compiled as type "float"
#define Ts 0.01f    //period of timer1 (s)
#define Servo_Period 20



//****************************************************************************** End of Define
 
//****************************************************************************** I/O
//PWM
PwmOut servo(A0);
//Timer Setting
Ticker timer;
//****************************************************************************** End of I/O
 
//****************************************************************************** Functions
void init_timer(void);
void init_PWM(void);
void timer_interrupt(void);
//****************************************************************************** End of Functions
 
//****************************************************************************** Variables
// Servo
float zero_degree_duty = 0.062; // 0.025~0.115(-90~+90)(not linear, so the experiment is needed)
float  pos_90degree_duty = 0.1067;    //0.1067 =true   //0.113
float  neg_90degree_duty = 0.026;     //0.025



//****************************************************************************** End of Variables
 
//****************************************************************************** Main
int main()
{
    init_timer();
    init_PWM();
    
    while(1)
    {
    }
}
//****************************************************************************** End of Main
 
//****************************************************************************** timer_interrupt
void timer_interrupt()
{
    
    
    static int counter =0;
    static float servo_counter =zero_degree_duty;
    
    counter ++;
    
    if(counter >= 600)
    {       
      return ;
            
   }
    else
    {
       if(counter %2 ==0)
       {                  
          servo_counter += ((pos_90degree_duty -zero_degree_duty)/300);
         //6sec 轉90度   
           servo.write(servo_counter);        
       }
        
     }
    
   
    
    // Code for servo motor    
}
//****************************************************************************** End of timer_interrupt
 
//****************************************************************************** init_timer
void init_timer()
{
     timer.attach_us(&timer_interrupt, 10000);//10ms interrupt period (100 Hz)
}
//****************************************************************************** End of init_timer
 
//****************************************************************************** init_PWM
void init_PWM()
{
    servo.period_ms(Servo_Period);
    servo.write(zero_degree_duty);
}
//****************************************************************************** End of init_PWM
