#include "mbed.h"
 Serial pc(USBTX, USBRX);
 //////////////////////////////////
InterruptIn HallA_1(A1);
InterruptIn HallB_1(A2);
// Motor2 sensor
InterruptIn HallA_2(D13);
InterruptIn HallB_2(D12);

PwmOut pwm1(D7);
PwmOut pwm1n(D11);
PwmOut pwm2(D8);
PwmOut pwm2n(A3);

///////////////////////////////////////
//DigitalOut led_D3(A4);
DigitalOut led_D4(A5);
///////////////////////////////////////
enum State {EMPTY=0,CW=1, CCW=2}state;
int Motor1_speedCount = 0;
void Speed_count();
float DetectRPM_Motor_1();
/////////////////////////////////
Timer RPM_timer;
Ticker timer;

int hallA_1 = 0;
int hallA_1_old = 0;
int hallB_1 = 0;
int hallB_1_old =0;
float pwm1_duty = 0.0f;

int hallA_2 = 0;
int hallA_2_old = 0;
int hallB_2 = 0;
int hallB_2_old = 0;
float pwm2_duty = 0.0f;

int temp=0;


////////
float DetectRPM_Motor_1();

void HallSensor();
void init_timer();
void init_function();
void init_hall();;
/////////////////////////////////
float DetectRPM_Motor_1()
{
    
    float time_difference = 0;    
    time_difference = Motor1_speedCount*100.0f/12.0f*60.0f;  
    return  time_difference;

}

void HallSensor()
{
    temp++;
           
    hallA_1 = HallA_1.read();
    hallB_1 = HallB_1.read();

    if(hallB_1-hallB_1_old==1 && hallA_1==0)
    {    
        Motor1_speedCount++;
        state = CW;
       // led_D4=1;
        
        //wait(1000);
       // led_D4 =0;
        
        //led_D3=0;
    }
    else if(hallB_1-hallB_1_old==-1 && hallA_1 == 1)
    {    
        Motor1_speedCount++;
        state = CW;
        //led_D4=0;
        
        //wait(1000);
        //led_D4 =1;
       // led_D3=0;
    }  
    
    else if(hallB_1-hallB_1_old==1 && hallA_1==1)
    {       
        Motor1_speedCount++;    
        state =CCW;
        //led_D3=1;
        //led_D4=0;
        
    }
    else if(hallB_1-hallB_1_old==-1 && hallA_1==0)
    {     
        Motor1_speedCount++;
        state = CCW;
       // led_D3=1;
        //led_D4=0;
    }
    
     hallA_1_old = hallA_1;
     hallB_1_old = hallB_1;
    
}
void timer_interrupt()
{  

    DetectRPM_Motor_1();
  //  Motor1_speedCount = 0;
  
    pwm1_duty = pwm1_duty+0.1;
   
    if(pwm1_duty>=1)
    {
        pwm1_duty=1;
    }
    
    //pwm1.write(pwm1_duty);
   
    pc.printf("%d",hallB_1);
    
    //pc.printf("A=");
    //pc.printf("%d ",hallA_1);
    //pc.printf("A_old=");
    //pc.printf("%d ",hallA_1_old);
   // pc.printf("B=");
   // pc.printf("%d ",hallB_1);
   // pc.printf("B_old=");
   // pc.printf("%d ",hallB_1_old);
   // pc.printf(" # ");

}



int main()
{
    pc.baud(9600);
    init_function();
    init_timer();
    init_hall();
    
    
    while(1)
    {
        ;
    }
    

    
}


void init_function()
{
     //led_D3=0;
     
     
     pwm1=0.0f;
     pwm1n=0.0f;
     pwm2=0.0f;
     pwm2n=0.0f;
     
     
     led_D4=0;
     hallA_1 = 0;
     hallA_1_old = 0;
     hallB_1 = 0;
     hallB_1_old =0;
     pwm1_duty = 0.0f;
    
     hallA_2 = 0;
     hallA_2_old = 0;
     hallB_2 = 0;
     hallB_2_old = 0;
     pwm2_duty = 0.0f;
}

void init_hall()
{
    HallA_1.enable_irq();
    HallB_1.enable_irq();
    
    HallA_1.rise(&HallSensor);
    HallA_1.fall(&HallSensor);
    HallB_1.rise(&HallSensor);
    HallB_1.fall(&HallSensor);
    
    hallA_1 = HallA_1.read();  
    hallB_1 = HallB_1.read();
      
    // Motor2
    HallA_2.rise(&HallSensor);
    HallA_2.fall(&HallSensor);
    HallB_2.rise(&HallSensor);
    HallB_2.fall(&HallSensor);
    
    hallA_2 = HallA_2.read();
    hallB_2 = HallB_2.read();
}


void init_timer()
{
     timer.attach_us(&timer_interrupt, 10000);//10ms interrupt period (100 Hz)
}
