#include "mbed.h"
#include "EthernetInterface.h"


/*
    By Andrea Campanella
    Just a small example how to use pushover.net
    with mbed and generally ho to use POST in mbed.
*/


int main()
{
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    // Pushover settings
    char pushoversite[] = "api.pushover.net";
    char apitoken[] = "APIKEY";
    char userkey [] = "USERKEY";
    char message [] = "Hello mate";
    TCPSocketConnection sock;
    sock.connect(pushoversite, 80);

    char http_cmd[300] = "POST /1/messages.json HTTP/1.1\r\n" ;
    char length[10];
    sprintf(length, "%d", 113 + sizeof(message)-1);
        
    //strcat( http_cmd , "POST /1/messages.json HTTP/1.1" ); 
    strcat( http_cmd , "Host: api.pushover.net\r\n");
    strcat( http_cmd , "Connection: close\r\n ");
    strcat( http_cmd , "Content-Type: application/x-www-form-urlencoded\r\n");
    strcat( http_cmd , "Content-Length: ");
    strcat( http_cmd , length);
    strcat( http_cmd , "\r\n\r\n");;
    strcat( http_cmd , "token=");
    strcat( http_cmd , apitoken);
    strcat( http_cmd , "&user=");
    strcat( http_cmd , userkey);
    strcat( http_cmd , "&message=");
    strcat( http_cmd , message);
    strcat( http_cmd , "&priority=");
    strcat( http_cmd , "0");
    strcat( http_cmd , "&retry=60");
    strcat( http_cmd , "&expire=3600");
    printf("Sending :%s\n",  http_cmd);

    sock.send_all(http_cmd, sizeof(http_cmd)-1);
  
    
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }

    sock.close();

    eth.disconnect();

    while(1) {}
}
