#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "eeprom.h"
#include <ctype.h>
#include "rtos.h"
#define USE_STM32746G_DISCOVERY
#include "stm32f7xx_hal.h"
#include "stm32746g_discovery.h"
#include "stm32746g_discovery_sd.h"
#include "string.h"
#include "stm32746g_discovery_lcd.h"
#include "ff_gen_drv.h"
#include "sd_diskio.h"
#include "XNucleoIHM02A1.h"
#include "wolfman.h"
#include "hfl.h"
#include "PCF85263AT.h"

#define FRAME_BUFFER    0xC0000000
#define SD_IN_BUFFER    0xC0140000
#define SD_OUT_BUFFER   0xC0280000


I2C i2c(D14,D15);        // sda, scl

char cmd[32];
dt_dat dt;   

FATFS SDFatFs;
FIL MyFile;

Thread thread;
Thread thread2;
Thread thread3;


LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

extern SD_HandleTypeDef uSdHandle;
DMA2D_HandleTypeDef hdma2d_disco;
Serial pc(USBTX, USBRX);

char SDPath[4];
//char text [40];
char c;

TS_StateTypeDef TS_State;

uint16_t x, y;
uint8_t text1[30];
uint8_t text2[30];
uint8_t text3[30];
uint8_t text4[60];
uint8_t text5[60];
uint8_t textn1[30];
uint8_t textn2[30];
uint8_t textn3[30];
uint8_t textn4[60];
uint8_t textn5[60];
uint8_t savereading[120];
uint8_t currenttime[60];
uint8_t idx;
uint8_t cleared = 0;
uint8_t prev_nb_touches = 0;
static uint8_t nus_buffer[20];
double Silver = 0.0;
double Copper = 0.0;
double LEDCUR = 0.0;
uint8_t cyclestep[7];
bool CuMODE = true;
bool AgMODE = true;
int screenstate = 0;
int MODE = 0;
int ZERO = 0.0;
int DARK = 0.0;
int READ = 0.0;
int LVL = 0.0;
double RAW = 0.0;
double SilverRAW = 0.0;
double CopperRAW = 0.0;
int writefail = 0;
int* toucharrow;
int* touchbutt;
bool ManMode = false;
FRESULT ress;
uint32_t  bytesread;
double TempCurrent = 0.0;

//PwmOut pump1(PA_8);

DigitalOut pump1(D0); // PA_8
DigitalOut pump2(D1);    //PA_15;
DigitalOut pump3(A3);
//DigitalOut pump4(A2);
DigitalOut pump5(A4);
DigitalOut pump6(A5);

PwmOut LED515(D10);
PwmOut LED480(A2);
DigitalOut LEDLD(D8);
DigitalOut LEDBL(D9);
DigitalOut Tempcs(A0);
DigitalOut Heat(A1);


SPI spi(D11, D12, D13); // mosi, miso, sclk
DigitalOut cs(D7);



/* Number of movements per revolution. */
#define MPR_1 4

/* Number of steps. */
#define STEPS_1 (200 * 128)   /* 1 revolution given a 400 steps motor configured at 1/128 microstep mode. */
#define STEPS_2 (STEPS_1 * 2)

/* Delay in milliseconds. */
#define DELAY_1 1000
#define DELAY_2 2000
#define DELAY_3 5000


///XNucleoIHM02A1 *x_nucleo_ihm02a1;
L6470_init_t init[L6470DAISYCHAINSIZE] = {
    /* First Motor. */
    {
               /* Ic configuration. */
    },

    /* Second Motor. */
    {
        12.0,                           /* Motor supply voltage in V. */
        200,                           /* Min number of steps per revolution for the motor. */
        1.5,                           /* Max motor phase voltage in A. */
        4.2,                          /* Max motor phase voltage in V. */
        100.0,                         /* Motor initial speed [step/s]. */
        400.0,                         /* Motor acceleration [step/s^2] (comment for infinite acceleration mode). */
        400.0,                         /* Motor deceleration [step/s^2] (comment for infinite deceleration mode). */
        900.0,                         /* Motor maximum speed [step/s]. */
        0.0,                           /* Motor minimum speed [step/s]. */
        902.7,                         /* Motor full-step speed threshold [step/s]. */
        1.5,                          /* Holding kval [V]. */
        5.2,                          /* Constant speed kval [V]. */
        5.2,                          /* Acceleration starting kval [V]. */
        5.2,                          /* Deceleration starting kval [V]. */
        371.52,                         /* Intersect speed for bemf compensation curve slope changing [step/s]. */
        392.1569e-6,                   /* Start slope [s/step]. */
        643.1372e-6,                   /* Acceleration final slope [s/step]. */
        643.1372e-6,                   /* Deceleration final slope [s/step]. */
        0,                             /* Thermal compensation factor (range [0, 15]). */
        3.06 * 1000 * 1.10,            /* Ocd threshold [ma] (range [375 ma, 6000 ma]). */
        3.06 * 1000 * 1.00,            /* Stall threshold [ma] (range [31.25 ma, 4000 ma]). */
        StepperMotor::STEP_MODE_1_128, /* Step mode selection. */
        0xFF,                          /* Alarm conditions enable. */
        0x2E88                         /* Ic configuration. */
    } 
};
    
XNucleoIHM02A1 *x_nucleo_ihm02a1 = new XNucleoIHM02A1(&init[0], &init[1], D5/*D14*/, D4/*D15*/, D2/*D4*/, D6/*A2*/, D11, D12, D13);
L6470 **motors = x_nucleo_ihm02a1->get_components();



/* Virtual address defined by the user: 0xFFFF value is prohibited */
uint16_t VirtAddVarTab[NB_OF_VAR] = {0x5555, 0x6666, 0x7777, 0x8888, 0x8899, 0x5655, 0x6776, 0x7887, 0x7117};
uint16_t VarDataTab[] = {2, 1, 5, 1, 1, 60, 1, 0, 0};


//ADC Struct for sensor
union LTC2400 {
    unsigned int raw;
    unsigned char byte[4];
    struct {
        unsigned int    
            sub:4,
            reading:24,
            exr:1,
            sgn:1,
            dmy:1,
            eoc:1;
    };
} adc;

//Prime Button
int primeon[4];
int pcount = 0;
//Man Button
int Manonoff[4];
//CuMODE Button
int CuMODEonoff[4];
//AgMODE Button
int AgMODEonoff[4];
//screen mode
int screenmode[4];
//All Button
int Aonoff[4];
bool Aon = 0;
//pump1
double p1count = 3;
int p1up[4];
int p1down[4];
int p1onoff[4];
bool p1on = false;
//pump2
double p2count = 5;
int p2up[4];
int p2down[4];
int p2onoff[4];
bool p2on = false;
//pump3
double p3count = 1;
int p3up[4];
int p3down[4];
int p3onoff[4];
bool p3on = false;
//pump4
double p4count = 1;
int p4up[4];
int p4down[4];
int p4onoff[4];
bool p4on = false;
//Sole5
double p5count = 1;
int p5up[4];
int p5down[4];
int p5onoff[4];
bool p5on = false;
//Pump6
double p6count = 6;
int p6up[4];
int p6down[4];
int p6onoff[4];
bool p6on = false;
//Pump7
double p7count = 1;
int p7up[4];
int p7down[4];
int p7onoff[4];
bool p7on = false;

//date/time
double d1count = 1;
int d1up[4];
int d1down[4];
double d2count = 1;
int d2up[4];
int d2down[4];
double d3count = 1;
int d3up[4];
int d3down[4];
double d4count = 1;
int d4up[4];
int d4down[4];
double d5count = 1;
int d5up[4];
int d5down[4];
int savedate[4];
double d6count = 0;
int d6up[4];
int d6down[4];


void set_ch(char sel)
{    // PCA9541のサンプル
        // MST_0側の自分にスレーブ側の制御権を得る場合
    cmd[0] = 1;                     // PCA9541 コマンドコード Cont Reg
    i2c.write( 0xe2, cmd, 1);       // Cont Regを指定
    i2c.read( 0xe2, cmd, 1);        // Cont Regを読込み
    wait(0.1);                      // 0.1s待つ
    switch(cmd[0] & 0xf)
    {
    case 0:                         // bus off, has control
    case 1:                         // bus off, no control
    case 5:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 4;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 2:                         // bus off, no control
    case 3:                         // bus off, has control
    case 6:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 5;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 9:                         // bus on, no control
    case 0xc:                       // bus on, no control
    case 0xd:                       // bus off, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 0;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 0xa:                       // bus on, no control
    case 0xe:                       // bus off, no control
    case 0xf:                       // bus on, has control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 1;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    default:
        break;
    }

    cmd[0] = sel;                   // PCA9546 Cont Reg sel channel enabled
    i2c.write( 0xe8, cmd, 1);       // Send command string
}

void  get_time(dt_dat *dt)      // 日時の取得
{
    cmd[0] = Seconds_100th;                       // 取得はレジスタSecondsから
    i2c.write(PCF85263AT_ADDR, cmd, 1);      // レジスタの設定
    i2c.read(PCF85263AT_ADDR, cmd, 8);       // SecondsからYearsまで取得
    cmd[1] &= 0x7f;                         // 有効なのは下位7ビット
    dt->s = (cmd[1] >> 4) * 10 + (cmd[1] & 0xf);    // BCDの数値化
    cmd[2] &= 0x7f;                         // 有効なのは下位7ビット
    dt->m = (cmd[2] >> 4) * 10 + (cmd[2] & 0xf);    // BCDの数値化
    cmd[3] &= 0x3f;                         // 有効なのは下位6ビット
    dt->h = (cmd[3] >> 4) * 10 + (cmd[3] & 0xf);    // BCDの数値化
    cmd[4] &= 0x3f;                         // 有効なのは下位6ビット
    dt->d = (cmd[4] >> 4) * 10 + (cmd[4] & 0xf);    // BCDの数値化
    dt->wd = (cmd[5] & 0x3);                        // BCDの数値化
    cmd[6] &= 0x1f;                         // 有効なのは下位5ビット
    dt->mm = (cmd[6] >> 4) * 10 + (cmd[6] & 0xf);   // BCDの数値化
    dt->y = (cmd[7] >> 4) * 10 + (cmd[7] & 0xf);    // BCDの数値化
}        

void set_time(dt_dat *dt)       // 日時の設定
{
    cmd[0] = Seconds_100th;                // 設定はレジスタSeconds_100thから
    cmd[1] = ((dt->s100th / 10) << 4) + (dt->s100th % 10);// 0.01秒のBCD化
    cmd[2] = ((dt->s / 10) << 4) + (dt->s % 10) + 0x80; // 秒のBCD化
    cmd[3] = ((dt->m / 10) << 4) + (dt->m % 10);        // 分のBCD化
    cmd[4] = ((dt->h / 10) << 4) + (dt->h % 10);        // 時のBCD化
    cmd[5] = ((dt->d / 10) << 4) + (dt->d % 10);        // 日のBCD化
    cmd[7] = ((dt->mm / 10) << 4) + (dt->mm % 10);      // 月のBCD化
    dt->y = dt->y - 2000;       
    cmd[8] = ((dt->y / 10) << 4) + (dt->y % 10);        // 年のBCD化
    i2c.write(PCF85263AT_ADDR, cmd, 9);      // 日時の設定
}




int * DrawButton(int x, int y, int w, int h){
    int* pointer;
    int butttouch[4];
    pointer = butttouch;                         
    lcd.FillRect(x, y, w, h);
    butttouch[0] = x;
    butttouch[1] = x+w;
    butttouch[2] = y;
    butttouch[3] = y+h;
    return pointer;     
}

int * DrawArrow(int x, int y, int d, int s){
    int* pointer;
    int arrowtouch[4];
    pointer = arrowtouch;
    if (d == 1) {
       Point points[] = {{x-10*s,y+10*s},{x,y},{x+10*s,y+10*s},{x+2*s,y+10*s},{x+2*s,y+20*s},{x-2*s,y+20*s},{x-2*s,y+10*s}};     
       lcd.FillPolygon(points,7);                
       arrowtouch[0] = x-10*s;
       arrowtouch[1] = x+10*s;
       arrowtouch[2] = y;
       arrowtouch[3] = y+20*s;
    } else if (d == 2) {
       Point points[] = {{x+10*s,y-10*s},{x,y},{x-10*s,y-10*s},{x-2*s,y-10*s},{x-2*s,y-20*s},{x+2*s,y-20*s},{x+2*s,y-10*s}};     
       lcd.FillPolygon(points,7);
       arrowtouch[0] = x-10*s;
       arrowtouch[1] = x+10*s;
       arrowtouch[2] = y-20*s;
       arrowtouch[3] = y;              
    } else if (d == 3) {
       Point points[] = {{x,y},{x-10*s,y-10*s},{x-10*s,y-2*s},{x-20*s,y-2*s},{x-20*s,y+2*s},{x-10*s,y+2*s},{x-10*s,y+10*s}};     
       lcd.FillPolygon(points,7);   
       arrowtouch[0] = x-10*s;
       arrowtouch[1] = x+10*s;
       arrowtouch[2] = y-20*s;
       arrowtouch[3] = y;     
    } else if (d == 4) {
       Point points[] = {{x,y},{x+10*s,y+10*s},{x+10*s,y+2*s},{x+20*s,y+2*s},{x+20*s,y-2*s},{x+10*s,y-2*s},{x+10*s,y-10*s}};     
       lcd.FillPolygon(points,7);   
       arrowtouch[0] = x-10*s;
       arrowtouch[1] = x+10*s;
       arrowtouch[2] = y-20*s;
       arrowtouch[3] = y;     
    } 
    return pointer;    
}
void runpump(){
    if (ManMode == true) {
        while (1) {
            //pump1
            if (p1on == true) {
                for (int j = 1; j<=p1count; j++) {
                    pump1 = 1;
                    Thread::wait(400);
                    pump1 = 0;
                    Thread::wait(600);
                }
            }
            //pump2
            if (p2on == true) {
                for (int j = 1; j<=p2count; j++) {
                    pump2 = 1;
                    Thread::wait(400);
                    pump2 = 0;
                    Thread::wait(600);
                }
            }
            //pump3
            if (p3on == true) {
                for (int j = 1; j<=p3count; j++) {
                    pump3 = 1;
                    Thread::wait(400);
                    pump3 = 0;
                    Thread::wait(600);
                }
            }
          /*  //pump4
            if (p4on == true) {
                for (int j = 1; j<=p4count; j++) {
                    pump4 = 1;
                    Thread::wait(400);
                    pump4 = 0;
                    Thread::wait(600);
                }
            } */
            //Sole5
            if (p5on == true) {
                for (int j = 1; j<=p5count; j++) {
                    pump5 = 1;
                    Thread::wait(5000);
                    pump5 = 0;
                    Thread::wait(300);
                }
            }
            //Pump6
            if (p6on == true) {
                for (int j = 1; j<=p6count; j++) {
                    pump6 = 1;
                    Thread::wait(100);
                    pump6 = 0;
                    Thread::wait(100);
                }
            }
            //Pump7
            if (p7on == true) {
                for (int j = 1; j<=p7count; j++) {
                    motors[1]->move(StepperMotor::BWD, STEPS_1*6.15);
                    //motors[1]->wait_while_active();
                    Thread::wait(300);
                }
            }            
            Thread::wait(2000);
        }
    } else {
        //pump1
        if (p1on == true) {
            for (int j = 1; j<=p1count; j++) {
                pump1 = 1;
                Thread::wait(400);
                pump1 = 0;
                Thread::wait(600);
            }
        }
        //pump2
        if (p2on == true) {
            for (int j = 1; j<=p2count; j++) {
                pump2 = 1;
                Thread::wait(400);
                pump2 = 0;
                Thread::wait(600);
            }
        }
        //pump3
        if (p3on == true) {
            for (int j = 1; j<=p3count; j++) {
                pump3 = 1;
                Thread::wait(400);
                pump3 = 0;
                Thread::wait(600);
            }
        }
      /*  //pump4
        if (p4on == true) {
            for (int j = 1; j<=p4count; j++) {
                pump4 = 1;
                Thread::wait(400);
                pump4 = 0;
                Thread::wait(600);
            }
        } */
        //Sole5
        if (p5on == true) {
            for (int j = 1; j<=p5count; j++) {
                pump5 = 1;
                Thread::wait(5000);
                //Wash cycle will go here
                pump5 = 0;
                Thread::wait(300);
            }
        }
        //Pump6
        if (p6on == true) {
            for (int j = 1; j<=p6count; j++) {
                pump6 = 1;
                Thread::wait(100);
                pump6 = 0;
                Thread::wait(100);
            }
        }
        //Pump7
        if (p7on == true) {
            for (int j = 1; j<=p7count; j++) {
                motors[1]->move(StepperMotor::BWD, STEPS_1*6.15);
                //motors[1]->wait_while_active();
                Thread::wait(4000);
            }
        }            

    }

}
void fill() {
    if (MODE != 6) { MODE = 5; }           
    p1on = false;
    p2on = false;
    p3on = false;
    p4on = false;
    p5on = false;
    p6on = false;   
    p7on = true;
    runpump();    
    if (MODE != 6) { MODE = 4; }  
}
void drain() {      
    p1on = false;
    p2on = false;
    p3on = false;
    p4on = false;
    p5on = true;
    p6on = false;   
    p7on = false;
    runpump();    
}
void wash() {
    MODE = 6;
    pump5 = 1;
    motors[1]->move(StepperMotor::BWD, STEPS_1*18.45);
    Thread::wait(4000);
    //motors[1]->wait_while_active();
    pump5 = 0;
    motors[1]->move(StepperMotor::BWD, STEPS_1*18.45);
    Thread::wait(4000);
    //motors[1]->wait_while_active();
    pump5 = 1;  
    Thread::wait(3000);
    pump5 = 0;               
    MODE = 4;    
   /* drain();       
    Thread::wait(100);
    fill();
    Thread::wait(100);
    drain();
    Thread::wait(100) ;     
    fill();
    Thread::wait(100);
    drain();
    Thread::wait(100) ; 
    fill();
    Thread::wait(100);
    drain();
    Thread::wait(100);
    fill();
    Thread::wait(100);
    fill();
    Thread::wait(100);
    fill();    
    Thread::wait(100);
    drain();
    Thread::wait(100);
    MODE = 4; */
}
void mix() {
    MODE = 7;
    p1on = false;
    p2on = false;
    p3on = false;
    p4on = false;
    p5on = false;
    p6on = true;
    p7on = false;    
    runpump();    
    Thread::wait(1000);
    MODE = 4;
    
}
void Agbuffer() {
    MODE = 8;
    p1on = true;
    p2on = false;
    p3on = false;
    p4on = false;
    p5on = false;
    p6on = false;
    p7on = false;      
    runpump();
    MODE = 4;
}
void Agindicator() {
    MODE = 9;
    p1on = false;
    p2on = true;
    p3on = false;
    p4on = false;
    p5on = false;
    p6on = false;
    p7on = false;      
    runpump();
    MODE = 4;   
}
void CuIndicator() {
    MODE = 10;
    p1on = false;
    p2on = false;
    p3on = true;
    p4on = false;
    p5on = false;
    p6on = false;
    p7on = false;      
    runpump();
    MODE = 4;      
}
void ClSoln() {
    MODE = 11;
    p1on = false;
    p2on = false;
    p3on = false;
    p4on = true;
    p5on = false;
    p6on = false;
    p7on = false;      
    runpump();
    MODE = 4;  
}
unsigned int read() {
    spi.format(8,0);
    cs = 0;
    Thread::wait(200);
    for( int i = 3; i >= 0; i-- ) {
        adc.byte[i] = spi.write( 0xFF );
    }
    cs = 1;    
 
    return adc.reading;
    
}
unsigned int readtemp() {
    spi.format(8,0);
    Tempcs = 0;
    Thread::wait(200);
    for( int i = 3; i >= 0; i-- ) {
        adc.byte[i] = spi.write( 0xFF );
    }
    Tempcs = 1;    
 
    return adc.reading;
    
}
unsigned int readl(int take) { 
    LED515.write(0.0);
    LED480.write(0.0);
    LEDLD = 0;
    LEDBL = 0;        
    unsigned int res = 1;
    unsigned int resp = 0;
    if (take == 0) {
        MODE = 0;
        LEDCUR=0.0;
        Thread::wait(2000);
        while (resp < res) {
            resp = read();
            res = read();
        }
        Thread::wait(2000);  
        unsigned int DF = read();
        unsigned int basereading = 0;  
        double i = 0.0;
        while (basereading <= DF) {        
            i = i + 0.001;
            LED515.write(i);
            res = 1;
            resp = 0; 
            while (resp < res) {
                resp = read();
                res = read();
            } 
            basereading = read();
        }
        LEDCUR = i + 0.001f;  
        LED515.write(i + 0.001f);
        Thread::wait(2000);
        while (resp < res) {
            resp = read();
            res = read();
        }                   
        res = read();           
        MODE = 4;        
        pc.printf("DARK: %d  LEDCUR: %f\r\n", res, LEDCUR);
        
    }
    if (take == 1) {
        MODE = 1;
        LED515.write(LEDCUR);
        while (read() <= 12000000) {
            LEDCUR = LEDCUR + 0.001f;
            LED515.write(LEDCUR);
        }
        Thread::wait(2000);
        while (resp < res) {
            resp = read();
            res = read();
        }                   
        res = read();        
        MODE = 4;
        pc.printf("ZERO: %d\r\n", res);
    }
    if (take == 2) {
        MODE = 2;
        LED515.write(LEDCUR);
        Thread::wait(2000);
        while (resp < res) {
            resp = read();
            res = read();
        }   
        res = read(); 
        MODE = 4;       
        pc.printf("READ: %d\r\n", res);
    }    
    if (take == 3) {
        MODE = 12;    
        LEDLD=1;
        Thread::wait(2000);
        while (resp < res) {
            resp = read();
            res = read();
        }   
        res = read();
        LEDLD=0; 
        MODE = 4;       
        pc.printf("Level: %d\r\n", res);
    }
    
    
    ///
        if (take == 4) {
        MODE = 0;
        LEDCUR=0.0;
        Thread::wait(2000);
        while (resp < res) {
            resp = read();
            res = read();
        }  
        Thread::wait(2000);
        unsigned int DF = read();
        unsigned int basereading = 0;  
        double i = 0.0;
        while (basereading <= DF) {        
            i = i + 0.001;
            LED480.write(i);
            res = 1;
            resp = 0; 
            while (resp < res) {
                resp = read();
                res = read();
            } 
            basereading = read();
        }
        LEDCUR = i + 0.001f;  
        LED480.write(i + 0.001f);
        Thread::wait(2000);
        while (resp < res) {
            resp = read();
            res = read();
        }                   
        res = read();           
        LED480.write(0.0);
        MODE = 4;        
        pc.printf("DARK: %d  LEDCUR: %f\r\n", res, LEDCUR);
        
    }
    if (take == 5) {
        MODE = 1; 
        LED480.write(LEDCUR);
        while (read() <= 12000000) {
            LEDCUR = LEDCUR + 0.001f;
            LED480.write(LEDCUR);
        }
        Thread::wait(2000);
        while (resp < res) {
            resp = read();
            res = read();
        }                   
        res = read();     
        LED480.write(0.0);   
        MODE = 4;
        pc.printf("ZERO: %d\r\n", res);
    }
    if (take == 6) {
        MODE = 2;
        LED480.write(LEDCUR);
        Thread::wait(2000);
        while (resp < res) {
            resp = read();
            res = read();
        }   
        res = read(); 
        LED480.write(0.0);
        MODE = 4;       
        pc.printf("READ: %d\r\n", res);
    }   
    ///         
    LEDBL=1;                
    return res;
}

void saveit() {
    Thread::wait(200);  
    get_time(&dt);
    Thread::wait(200);
    memset((char*)savereading,0,sizeof(savereading));
    Thread::wait(1000);  
    sprintf((char*)savereading, "%04d/%02d/%02d %02d:%02d:%02d,%0.1f,%0.5f,%0.1f,%0.5f,%0.5f,%0.5f,%0.5f\n", 2000 + dt.y, dt.mm, dt.d, dt.h, dt.m, dt.s, Silver, SilverRAW, Copper, CopperRAW, ((double)DARK/16777216)*3.302, ((double)ZERO/16777216)*3.302, ((double)READ/16777216)*3.302);
    Thread::wait(1000);       

    ress = f_open(&MyFile, "Log.csv", FA_WRITE);   
    Thread::wait(200);   
    if(ress!= FR_OK) {
            pc.printf("Failed to open file\n");
            ress = f_open(&MyFile, "Log.csv", FA_CREATE_ALWAYS); 
            if(ress!= FR_OK) {
                pc.printf("Failed to open file\n");
            }
        }
    Thread::wait(200);      
    f_lseek(&MyFile, f_size(&MyFile));
    Thread::wait(200);  
    ress = f_write(&MyFile, savereading, sizeof(savereading), &bytesread);
    Thread::wait(200);  
    if(ress!= FR_OK) {
        pc.printf("Failed to write file 1\n");
        MODE = 13;
        writefail = 1;
        Thread::wait(3000);                  
    } else {    
        pc.printf("Done!\n");
        MODE = 11;
        writefail = 0;
    }                    
    Thread::wait(200);  
    f_close(&MyFile);
   /* Thread::wait(200);  
    FATFS_UnLinkDriver(SDPath); */
}

void ReadSilver() {
    sprintf((char*)cyclestep, " - Ag");
    wash();
    //Thread::wait(30000); //to give heater time to warm water 
    LVL = readl(3);
    while (LVL > 9000000) {
        fill();
        LVL = readl(3);
    }       
    Thread::wait(2000);
    DARK = readl(0); 
    Thread::wait(2000);
    ZERO = readl(1);
    Agbuffer();
    mix();
    Agindicator();
    mix();
    Thread::wait(60000);
    sprintf((char*)cyclestep, " - Ag");
    READ = readl(2); 
    double x = abs(((float)READ-(float)DARK)/((float)ZERO-(float)DARK));
    x = 2-log10(x*100);
    RAW = x;
    SilverRAW = RAW;   
    //y = 10726x^2 – 301.98x – 5.1693
    x = 10726*pow(x,2) - 301.98*x - 5.1693;
    if (x<0.0){ x=0.0;}
    Silver = x;
    sprintf((char*)cyclestep, "");     
    saveit(); 
}
void ReadCopper() {
    sprintf((char*)cyclestep, " - Cu");
    wash();
    //Thread::wait(30000); //to give heater time to warm water   
    LVL = readl(3);
    while (LVL > 9000000) {
        fill();
        LVL = readl(3);
    }    
    Thread::wait(2000);
    DARK = readl(4);      
    Thread::wait(2000);    
    ZERO = readl(5);
    CuIndicator();
    mix();
    Thread::wait(60000);
    sprintf((char*)cyclestep, " - Cu");
    READ = readl(6); 
    double x = abs(((float)READ-(float)DARK)/((float)ZERO-(float)DARK));
    x = 2-log10(x*100);
    RAW = x;
    CopperRAW = RAW;
    //y = 4852.2x – 9.5947  
    x = 4852.2*x - 9.5947;
    if (x<0.0){ x=0.0;}
    Copper = x;
    sprintf((char*)cyclestep, "");      
    saveit();
}
void ThermoStat() {
    TempCurrent = ((readtemp()/16777216.0) - 0.3756) * 660;
    pc.printf("%0.2f",TempCurrent);
    if (TempCurrent >= 41.0) { Heat = 0;}
    if (TempCurrent < 38.0) { Heat = 1;}
    }
void reprime();
void takereading() {
    while (1) {
        LED515.write(0.0);
        LED480.write(0.0);
        LEDLD = 0;
        LEDBL = 0;
        LEDCUR = 0.0;        
        if (ManMode == true) {
            DARK = readl(0);
            ZERO = readl(1);
            Thread::wait(5000);
            READ = readl(2);
            double x = abs(((float)READ-(float)DARK)/((float)ZERO-(float)DARK));
            x = 2-log10(x*100);
            //x = 10.297*pow(x,2) - 21.909*x + 11.453;
            if (x < 0.0) { x = 0.0; }
            Copper = x;
            Silver = x;            
        }
        if (ManMode == false) {
            ThermoStat();
            if (AgMODE == true) { ReadSilver(); }
            if (CuMODE == true) { ReadCopper(); } 
            drain(); 
            for (int d6chld = 0; d6chld < d6count*56; d6chld++){             
                Thread::wait(60000);
            }    
            if (d6count > 0) { reprime(); }
        }
    }
}

void prime(){
    MODE = 3;
    thread3.terminate(); 
    pump5 = 1;
    for (pcount = 0; pcount < 25; pcount++) {
        
        pump1 = 1;
        Thread::wait(200);
        pump1 = 0;

        pump2 = 1;
        Thread::wait(200);
        pump2 = 0;

        pump3 = 1;
        Thread::wait(200);
        pump3 = 0;

       /* pump4 = 1;
        Thread::wait(200);
        pump4 = 0; */
 
        pump6 = 1;
        Thread::wait(200);
        pump6 = 0;
        
        motors[1]->move(StepperMotor::BWD, STEPS_1*6.15);
        //motors[1]->wait_while_active();       


    }      
    Thread::wait(5000);
    pump5 = 0;
    Thread::wait(300);
    if (ManMode == true) {  thread2.start(runpump); }
    thread3.start(takereading); 
    pcount = 0;
    MODE = 4;
}

void reprime(){
    MODE = 3;
    pump5 = 1;
    for (pcount = 0; pcount < 5; pcount++) {
        
        pump1 = 1;
        Thread::wait(200);
        pump1 = 0;

        pump2 = 1;
        Thread::wait(200);
        pump2 = 0;

        pump3 = 1;
        Thread::wait(200);
        pump3 = 0;

       /* pump4 = 1;
        Thread::wait(200);
        pump4 = 0; */
 
        pump6 = 1;
        Thread::wait(200);
        pump6 = 0;
      
    }      
    Thread::wait(2000);
    pump5 = 0;
    Thread::wait(300);
    pcount = 0;
    MODE = 4;
}

void screencycle();
void setdatetime() {
    cmd[0] = Oscillator;              // Aging_offset
    cmd[1] = 0x80 + 0x40 + 0x1;                       // -1ppm
    i2c.write(PCF85263AT_ADDR, cmd, 2);  // Aging_offset

    cmd[0] = Function;              // Aging_offset
    cmd[1] = 0x1;                       // -1ppm
    i2c.write(PCF85263AT_ADDR, cmd, 2);  // Aging_offset

    cmd[0] = Offset;              // Aging_offset
    cmd[1] = 60;                       // -1ppm
    i2c.write(PCF85263AT_ADDR, cmd, 2);  // Aging_offse


    dt.y = 2000+(int)d3count;                
    dt.mm = (int)d1count;                 
    dt.d = (int)d2count;                   
    dt.h = (int)d4count;                  
    dt.m = (int)d5count;                  
    dt.s = 0;                   
    set_time(&dt);              
    
}
void screen() {       
        while(1) {     
        if (p1count<0){p1count=0;}
        if (p2count<0){p2count=0;}
        if (p3count<0){p3count=0;}
        if (p4count<0){p4count=0;}
        if (p5count<0){p5count=0;}
        if (p6count<0){p6count=0;}  
        if (p7count<0){p7count=0;}                       
        //pump1.pulsewidth(p1count/750000);
        
        if (p1on == true || p2on == true || p3on == true || p4on == true || p5on == true || p6on == true || p7on == true) {  Aon = true; }
        if (p1on == false && p2on == false && p3on == false && p4on == false && p5on == false && p6on == false && p7on == false) {  Aon = false; }
        
        
        if (writefail == 1) {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillCircle(235,175,10);
        }    
        
        //General Display
        lcd.SetFont(&Font16);  
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);
        sprintf((char*)textn1, "%0.1f/%0.5f Ag", Silver, SilverRAW);
        if (strcmp((char*)text1,(char*)textn1) != 0) {           
            sprintf((char*)text1, "%0.1f/%0.5f Ag", Silver, SilverRAW);
            lcd.ClearStringLine(13);
        }
        lcd.DisplayStringAt(0, LINE(13), (uint8_t *)&text1, CENTER_MODE);       
       
        
        lcd.SetFont(&Font16);  
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);                                
        sprintf((char*)textn4, "%0.1f/%0.5f Cu L:%d", Copper, CopperRAW, LVL);
        if (strcmp((char*)text4,(char*)textn4) != 0) {         
            sprintf((char*)text4, "%0.1f/%0.5f Cu L:%d", Copper, CopperRAW, LVL);
            lcd.ClearStringLine(14);
        }
        lcd.DisplayStringAt(0, LINE(14), (uint8_t *)&text4, CENTER_MODE);  
        
        
        
        lcd.SetTextColor(LCD_COLOR_DARKGRAY);                                  
        sprintf((char*)textn4, "RAW=%0.4f | %d | %d | %d", RAW, DARK, ZERO, READ);
        if (strcmp((char*)text4,(char*)textn4) != 0) {         
            sprintf((char*)text4, "RAW=%0.4f | %d | %d | %d", RAW, DARK, ZERO, READ);
            lcd.ClearStringLine(15);
        }
        lcd.DisplayStringAt(0, LINE(15), (uint8_t *)&text4, CENTER_MODE);                                          
                                          
        sprintf((char*)textn5, "RAW Volts=%0.3f | %0.3f | %0.3f", ((double)DARK/16777216)*3.302, ((double)ZERO/16777216)*3.302, ((double)READ/16777216)*3.302);
        if (strcmp((char*)text5,(char*)textn5) != 0) {         
            sprintf((char*)text5, "RAW Volts=%0.3f | %0.3f | %0.3f", ((double)DARK/16777216)*3.302, ((double)ZERO/16777216)*3.302, ((double)READ/16777216)*3.302);
            lcd.ClearStringLine(16);
        }
        lcd.DisplayStringAt(0, LINE(16), (uint8_t *)&text5, CENTER_MODE);     
            
            
                                          
        if (MODE == 0 && (strcmp((char*)text3,"Dark Reading") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Dark Reading");             
        }
        if (MODE == 1 && (strcmp((char*)text3,"Zeroing") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Zeroing"); 
        }
        if (MODE == 2 && (strcmp((char*)text3,"Reading") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Reading"); 
        }  
        if (MODE == 3 && (strcmp((char*)text3,"Priming") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Priming"); 
        }  
        sprintf((char*)textn3, "Waiting%s", cyclestep);         
        if (MODE == 4 && (strcmp((char*)text3,(char*)textn3) != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Waiting%s", cyclestep);             
        }
        if (MODE == 5 && (strcmp((char*)text3,"Sampling") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Sampling"); 
        }
        if (MODE == 6 && (strcmp((char*)text3,"Washing") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Washing"); 
        }
        if (MODE == 7 && (strcmp((char*)text3,"Mixing") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Mixing"); 
        }
        if (MODE == 8 && (strcmp((char*)text3,"Ag Buffer Dosing") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Ag Buffer Dosing"); 
        }                
        if (MODE == 9 && (strcmp((char*)text3,"Ag Indicator Dosing") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Ag Indicator Dosing"); 
        }
        if (MODE == 10 && (strcmp((char*)text3,"Cu Indicator Dosing") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Cu Indicator Dosing"); 
        }     
        if (MODE == 11 && (strcmp((char*)text3,"Write Success") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Write Success"); 
        }
        if (MODE == 12 && (strcmp((char*)text3,"Level") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Level"); 
        }
        if (MODE == 13 && (strcmp((char*)text3,"Write Fail") != 0)) { 
            lcd.ClearStringLine(12);
            sprintf((char*)text3, "Write Fail"); 
        }             
             
        lcd.SetTextColor(LCD_COLOR_LIGHTRED);   
        lcd.DisplayStringAt(0, LINE(12), (uint8_t *)&text3, CENTER_MODE); 
        
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);   
        lcd.SetFont(&Font24);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"WOLFMAN", CENTER_MODE);


        //Prime Button
        lcd.SetFont(&Font12);
        if (pcount == 0) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(20,  2, 50, 15);
            for( int i = 0 ; i < 4 ; ++i ){ primeon[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(20,  2, (uint8_t *)"Prime", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(20, 2, 50, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ primeon[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            sprintf((char*)nus_buffer, "%d", (int)pcount);
            lcd.DisplayStringAt(20, 2, (uint8_t *)nus_buffer, LEFT_MODE); 
        }  

       //Screen Mode
        //lcd.SetTextColor(LCD_COLOR_GREEN);
        //lcd.SetBackColor(LCD_COLOR_GREEN);
        touchbutt = DrawButton(230, 30, 50, 15);
        for( int i = 0 ; i < 4 ; ++i ){ screenmode[ i ] = touchbutt[ i ]; }    


        //Cu Only Button
        lcd.SetFont(&Font12);
        if (CuMODE == false) { 
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(90, 2, 25, 15);
            for( int i = 0 ; i < 4 ; ++i ){ CuMODEonoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(90, 2, (uint8_t *)"Cu", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(90, 2, 25, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ CuMODEonoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(90, 2, (uint8_t *)"Cu", LEFT_MODE); 
        }  
        //Ag Only Button
        lcd.SetFont(&Font12);
        if (AgMODE == false) { 
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(130, 2, 25, 15);
            for( int i = 0 ; i < 4 ; ++i ){ AgMODEonoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(130, 2, (uint8_t *)"Ag", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(130, 2, 25, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ AgMODEonoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(130, 2, (uint8_t *)"Ag", LEFT_MODE); 
        }  
        


        //Mode Button
        lcd.SetFont(&Font12);
        if (ManMode == true) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(340, 2, 50, 15);
            for( int i = 0 ; i < 4 ; ++i ){ Manonoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(346, 5, (uint8_t *)"Manual", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(340, 2, 50, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ Manonoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(348, 5, (uint8_t *)"Auto", LEFT_MODE); 
        }  
              
        
        
        
        //All Button
        lcd.SetFont(&Font12);
        if (Aon == true) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(410, 2, 50, 15);
            for( int i = 0 ; i < 4 ; ++i ){ Aonoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(411, 5, (uint8_t *)"All ON", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(410, 2, 50, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ Aonoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(410, 5, (uint8_t *)"All OFF", LEFT_MODE); 
        }           
      
        //pump 1 controls
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        lcd.DisplayStringAt(10, 30, (uint8_t *)"AgBuf", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(30,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ p1up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(30,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ p1down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)p1count);
        lcd.DisplayStringAt(30, 95, (uint8_t *)nus_buffer, LEFT_MODE);        
        if (p1on == true) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(10, 165, 40, 15);
            for( int i = 0 ; i < 4 ; ++i ){ p1onoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(20, 168, (uint8_t *)"ON", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(10, 165, 40, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ p1onoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(20, 168, (uint8_t *)"OFF", LEFT_MODE); 
        }              



        //pump 2 controls
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE); 
        lcd.DisplayStringAt(80, 30, (uint8_t *)"AgInd", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(100,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ p2up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(100,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ p2down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)p2count);
        lcd.DisplayStringAt(100, 95, (uint8_t *)nus_buffer, LEFT_MODE);
        if (p2on == true) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(80, 165, 40, 15);
            for( int i = 0 ; i < 4 ; ++i ){ p2onoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(90, 168, (uint8_t *)"ON", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(80, 165, 40, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ p2onoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(90, 168, (uint8_t *)"OFF", LEFT_MODE); 
        }      



        //pump 3 controls
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE); 
        lcd.DisplayStringAt(150, 30, (uint8_t *)"CuInd", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(170,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ p3up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(170,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ p3down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)p3count);
        lcd.DisplayStringAt(170, 95, (uint8_t *)nus_buffer, LEFT_MODE);
        if (p3on == true) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(150, 165, 40, 15);
            for( int i = 0 ; i < 4 ; ++i ){ p3onoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(160, 168, (uint8_t *)"ON", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(150, 165, 40, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ p3onoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(160, 168, (uint8_t *)"OFF", LEFT_MODE); 
        }      



/*
        //pump 4 controls
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        lcd.DisplayStringAt(220, 30, (uint8_t *)"OCl", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(240,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ p4up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(240,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ p4down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)p4count);
        lcd.DisplayStringAt(240, 95, (uint8_t *)nus_buffer, LEFT_MODE);
        if (p4on == true) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(220, 165, 40, 15);
            for( int i = 0 ; i < 4 ; ++i ){ p4onoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(230, 168, (uint8_t *)"ON", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(220, 165, 40, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ p4onoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(230, 168, (uint8_t *)"OFF", LEFT_MODE); 
        }         
 */       
        
        //Solenoid 5 controls
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        lcd.DisplayStringAt(285, 30, (uint8_t *)"Drain", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(310,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ p5up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(310,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ p5down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)p5count);
        lcd.DisplayStringAt(310, 95, (uint8_t *)nus_buffer, LEFT_MODE);        
        if (p5on == true) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(290, 165, 40, 15);
            for( int i = 0 ; i < 4 ; ++i ){ p5onoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(300, 168, (uint8_t *)"ON", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(290, 165, 40, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ p5onoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(300, 168, (uint8_t *)"OFF", LEFT_MODE); 
        }      
        //Pump 6 controls
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        lcd.DisplayStringAt(360, 30, (uint8_t *)"Mix", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(380,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ p6up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(380,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ p6down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)p6count);
        lcd.DisplayStringAt(380, 95, (uint8_t *)nus_buffer, LEFT_MODE);        
        if (p6on == true) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(360, 165, 40, 15);
            for( int i = 0 ; i < 4 ; ++i ){ p6onoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(370, 168, (uint8_t *)"ON", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(360, 165, 40, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ p6onoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(370, 168, (uint8_t *)"OFF", LEFT_MODE); 
        }    
        //Pump 7 controls
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        lcd.DisplayStringAt(430, 30, (uint8_t *)"Fill", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(450,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ p7up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(450,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ p7down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)p7count);
        lcd.DisplayStringAt(450, 95, (uint8_t *)nus_buffer, LEFT_MODE);        
        if (p7on == true) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(430, 165, 40, 15);
            for( int i = 0 ; i < 4 ; ++i ){ p7onoff[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(440, 168, (uint8_t *)"ON", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(430, 165, 40, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ p7onoff[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(440, 168, (uint8_t *)"OFF", LEFT_MODE); 
        }         
     
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE); 
        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

      /*      sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE); */



            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                double touchsensativity = 0.075; //(0.055 originaly)             
                

                if (( x >= primeon[0] && x <= primeon[1] ) && (y >= primeon[2] && y <= primeon[3])) {
                    thread2.terminate();
                    if (pcount != 0) {
                        pcount = 0;                           
                        thread2.start(takereading);
                    }
                    else {
                        ManMode = false;
                        Aon = false;
                        p1on = false;
                        p2on = false;
                        p3on = false;
                        p4on = false;
                        p5on = false;
                        p6on = false;   
                        p7on = false;                                              
                        thread2.start(prime);
                    }
                    Thread::wait(300);
                }

                
              if (( x >= Manonoff[0] && x <= Manonoff[1] ) && (y >= Manonoff[2] && y <= Manonoff[3])){
                    ManMode = !ManMode;
                    //motors[1]->wait_while_active();
                    if (ManMode == true) {
                        thread2.terminate();
                        p1on = false;
                        p2on = false;
                        p3on = false;
                        p4on = false;
                        p5on = false;
                        p6on = false;   
                        p7on = false;                                                                       
                        thread2.start(runpump);
                        thread3.terminate();
                        thread3.start(takereading);                            
                    } else {                        
                        thread2.terminate();
                        thread3.terminate();
                        thread3.start(takereading);                                                                       
                    }
                    Thread::wait(200); 
                }
                
                if (( x >= CuMODEonoff[0] && x <= CuMODEonoff[1] ) && (y >= CuMODEonoff[2] && y <= CuMODEonoff[3])){ CuMODE = !CuMODE; }                   
                if (( x >= AgMODEonoff[0] && x <= AgMODEonoff[1] ) && (y >= AgMODEonoff[2] && y <= AgMODEonoff[3])){ AgMODE = !AgMODE; } 
                 
                if (( x >= screenmode[0] && x <= screenmode[1] ) && (y >= screenmode[2] && y <= screenmode[3])){ 
                    screenstate = screenstate + 1;
                    if (screenstate > 2){ screenstate = 0; } 
                    Thread::wait(200);
                    EE_WriteVariable(VirtAddVarTab[7], (uint16_t)screenstate);          
                    screencycle();
                    return;                           
                }         
                            
  
                if (( x >= Aonoff[0] && x <= Aonoff[1] ) && (y >= Aonoff[2] && y <= Aonoff[3])){
                    Aon = !Aon;
                    if (Aon == true) {
                        p1on = true;
                        p2on = true;
                        p3on = true;
                        p4on = true;
                        p5on = true;
                        p6on = true;
                        p7on = true;                         
                    } else {
                        p1on = false;
                        p2on = false;
                        p3on = false;
                        p4on = false;
                        p5on = false;
                        p6on = false;                        
                        p7on = false;                         
                    }
                    Thread::wait(200);
                    //EE_WriteVariable(VirtAddVarTab[0], (uint16_t)p1count);  
                }     
                              
                //pump1
                if (( x >= p1up[0] && x <= p1up[1] ) && (y >= p1up[2] && y <= p1up[3])){
                    p1count = p1count + touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[0], (uint16_t)p1count);                                                         
                    
                }
                if (( x >= p1down[0] && x <= p1down[1] ) && (y >= p1down[2] && y <= p1down[3])){
                    p1count = p1count - touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[0], (uint16_t)p1count);  
                } 
                if (( x >= p1onoff[0] && x <= p1onoff[1] ) && (y >= p1onoff[2] && y <= p1onoff[3])){
                    p1on = !p1on;
                    Thread::wait(200);
                }          
                //pump2
                if (( x >= p2up[0] && x <= p2up[1] ) && (y >= p2up[2] && y <= p2up[3])){
                    p2count = p2count + touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[1], (uint16_t)p2count);                                                         
                    
                }
                if (( x >= p2down[0] && x <= p2down[1] ) && (y >= p2down[2] && y <= p2down[3])){
                    p2count = p2count - touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[1], (uint16_t)p2count);  
                }               
                if (( x >= p2onoff[0] && x <= p2onoff[1] ) && (y >= p2onoff[2] && y <= p2onoff[3])){
                    p2on = !p2on;
                    Thread::wait(200);
                }          
                //pump3
                if (( x >= p3up[0] && x <= p3up[1] ) && (y >= p3up[2] && y <= p3up[3])){
                    p3count = p3count + touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[2], (uint16_t)p3count);                                                         
                    
                }
                if (( x >= p3down[0] && x <= p3down[1] ) && (y >= p3down[2] && y <= p3down[3])){
                    p3count = p3count - touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[2], (uint16_t)p3count);  
                }
                if (( x >= p3onoff[0] && x <= p3onoff[1] ) && (y >= p3onoff[2] && y <= p3onoff[3])){
                    p3on = !p3on;
                    Thread::wait(200);
                }                                        
              /*  //pump4
                if (( x >= p4up[0] && x <= p4up[1] ) && (y >= p4up[2] && y <= p4up[3])){
                    p4count = p4count + touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[3], (uint16_t)p4count);                                                         
                    
                }
                if (( x >= p4down[0] && x <= p4down[1] ) && (y >= p4down[2] && y <= p4down[3])){
                    p4count = p4count - touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[3], (uint16_t)p4count);  
                }
                if (( x >= p4onoff[0] && x <= p4onoff[1] ) && (y >= p4onoff[2] && y <= p4onoff[3])){
                    p4on = !p4on;
                    Thread::wait(200);
                }                  */ 
                //Sole5
                if (( x >= p5up[0] && x <= p5up[1] ) && (y >= p5up[2] && y <= p5up[3])){
                    p5count = p5count + touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[4], (uint16_t)p5count);                                                         
                    
                }
                if (( x >= p5down[0] && x <= p5down[1] ) && (y >= p5down[2] && y <= p5down[3])){
                    p5count = p5count - touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[4], (uint16_t)p5count);  
                }                      
                if (( x >= p5onoff[0] && x <= p5onoff[1] ) && (y >= p5onoff[2] && y <= p5onoff[3])){
                    p5on = !p5on;
                    Thread::wait(200);
                }    
                //Pump6
                if (( x >= p6up[0] && x <= p6up[1] ) && (y >= p6up[2] && y <= p6up[3])){
                    p6count = p6count + touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[5], (uint16_t)p6count);                                                         
                    
                }
                if (( x >= p6down[0] && x <= p6down[1] ) && (y >= p6down[2] && y <= p6down[3])){
                    p6count = p6count - touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[5], (uint16_t)p6count);  
                }                      
                if (( x >= p6onoff[0] && x <= p6onoff[1] ) && (y >= p6onoff[2] && y <= p6onoff[3])){
                    p6on = !p6on;
                    Thread::wait(200);
                }                        
                //Pump7
                if (( x >= p7up[0] && x <= p7up[1] ) && (y >= p7up[2] && y <= p7up[3])){
                    p7count = p7count + touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[6], (uint16_t)p7count);                                                         
                    
                }
                if (( x >= p7down[0] && x <= p7down[1] ) && (y >= p7down[2] && y <= p7down[3])){
                    p7count = p7count - touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[6], (uint16_t)p7count);  
                }                      
                if (( x >= p7onoff[0] && x <= p7onoff[1] ) && (y >= p7onoff[2] && y <= p7onoff[3])){
                    p7on = !p7on;
                    Thread::wait(200);
                }                                            
                               
          /*      sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                lcd.DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);            */
            } 
            lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
        } else {
            if (!cleared) {
                lcd.Clear(LCD_COLOR_BLACK);
              /*  sprintf((char*)text, "Touches: 0");
                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);            */
                cleared = 1;
            }
        }
        
    }
}

////////////
void screen2() {
        while(1) {     
        if (p1count<0){p1count=0;}
        if (p2count<0){p2count=0;}
        if (p3count<0){p3count=0;}
        if (p4count<0){p4count=0;}
        if (p5count<0){p5count=0;}
        if (p6count<0){p6count=0;}  
        if (p7count<0){p7count=0;}                       
        //pump1.pulsewidth(p1count/750000);
        
        if (p1on == true || p2on == true || p3on == true || p4on == true || p5on == true || p6on == true || p7on == true) {  Aon = true; }
        if (p1on == false && p2on == false && p3on == false && p4on == false && p5on == false && p6on == false && p7on == false) {  Aon = false; }
        
        if (writefail == 1) {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillCircle(235,190,10);
        }    
        
        //General Display
        lcd.SetFont(&Font20);  
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);
        sprintf((char*)textn1, "%0.1f ppb Ag+", Silver);
        /* if (strcmp((char*)text1,(char*)textn1) != 0) {           
            sprintf((char*)text1, "%0.1f ppm Ag+", Silver);
            lcd.ClearStringLine(4);
        } */
        lcd.DisplayStringAt(0, LINE(4), (uint8_t *)&textn1, CENTER_MODE);       
        
        lcd.SetFont(&Font20);  
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);
        sprintf((char*)textn1, "%0.1f ppb Cu2+", Copper);
       /* if (strcmp((char*)text1,(char*)textn1) != 0) {           
            sprintf((char*)text1, "%0.1f ppm Cu2+", Copper);
            lcd.ClearStringLine(9);
        } */
        lcd.DisplayStringAt(0, LINE(7), (uint8_t *)&textn1, CENTER_MODE); 
        
       
            
            
        lcd.SetFont(&Font16);                                   
        if (MODE == 0 && (strcmp((char*)text3,"Dark Reading") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Dark Reading");             
        }
        if (MODE == 1 && (strcmp((char*)text3,"Zeroing") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Zeroing"); 
        }
        if (MODE == 2 && (strcmp((char*)text3,"Reading") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Reading"); 
        }  
        if (MODE == 3 && (strcmp((char*)text3,"Priming") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Priming"); 
        }  
        sprintf((char*)textn3, "Waiting%s", cyclestep);         
        if (MODE == 4 && (strcmp((char*)text3,(char*)textn3) != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Waiting%s", cyclestep);             
        }
        if (MODE == 5 && (strcmp((char*)text3,"Sampling") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Sampling"); 
        }
        if (MODE == 6 && (strcmp((char*)text3,"Washing") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Washing"); 
        }
        if (MODE == 7 && (strcmp((char*)text3,"Mixing") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Mixing"); 
        }
        if (MODE == 8 && (strcmp((char*)text3,"Ag Buffer Dosing") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Ag Buffer Dosing"); 
        }                
        if (MODE == 9 && (strcmp((char*)text3,"Ag Indicator Dosing") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Ag Indicator Dosing"); 
        }
        if (MODE == 10 && (strcmp((char*)text3,"Cu Indicator Dosing") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Cu Indicator Dosing"); 
        }     
        if (MODE == 11 && (strcmp((char*)text3,"Write Success") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Write Success"); 
        }
        if (MODE == 12 && (strcmp((char*)text3,"Level") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Level"); 
        }             
        if (MODE == 13 && (strcmp((char*)text3,"Write Fail") != 0)) { 
            lcd.ClearStringLine(15);
            sprintf((char*)text3, "Write Fail"); 
        }
             
        lcd.SetTextColor(LCD_COLOR_LIGHTRED);   
        lcd.DisplayStringAt(0, LINE(15), (uint8_t *)&text3, CENTER_MODE); 
        
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);   
        lcd.SetFont(&Font24);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"Cu/Ag Ion Monitor", CENTER_MODE);


        //Prime Button
        lcd.SetFont(&Font12);
        if (pcount == 0) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(20,  2, 50, 15);
            for( int i = 0 ; i < 4 ; ++i ){ primeon[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(20,  2, (uint8_t *)"Prime", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(20, 2, 50, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ primeon[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            sprintf((char*)nus_buffer, "%d", (int)pcount);
            lcd.DisplayStringAt(20, 2, (uint8_t *)nus_buffer, LEFT_MODE); 
        }  


       //Screen Mode
        //lcd.SetTextColor(LCD_COLOR_GREEN);
        //lcd.SetBackColor(LCD_COLOR_GREEN);
        touchbutt = DrawButton(230, 30, 50, 15);
        for( int i = 0 ; i < 4 ; ++i ){ screenmode[ i ] = touchbutt[ i ]; }             



    
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE); 
        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

      /*      sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE); */



            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                double touchsensativity = 0.075; //(0.055 originaly)             
                

                if (( x >= primeon[0] && x <= primeon[1] ) && (y >= primeon[2] && y <= primeon[3])) {
                    thread2.terminate();
                    if (pcount != 0) {
                        pcount = 0;                           
                        thread2.start(takereading);
                    }
                    else {
                        ManMode = false;
                        Aon = false;
                        p1on = false;
                        p2on = false;
                        p3on = false;
                        p4on = false;
                        p5on = false;
                        p6on = false;   
                        p7on = false;                                              
                        thread2.start(prime);
                    }
                    Thread::wait(300);
                }

                
              if (( x >= Manonoff[0] && x <= Manonoff[1] ) && (y >= Manonoff[2] && y <= Manonoff[3])){
                    ManMode = !ManMode;
                    //motors[1]->wait_while_active();
                    if (ManMode == true) {
                        thread2.terminate();
                        p1on = false;
                        p2on = false;
                        p3on = false;
                        p4on = false;
                        p5on = false;
                        p6on = false;   
                        p7on = false;                                                                       
                        thread2.start(runpump);
                        thread3.terminate();
                        thread3.start(takereading);                            
                    } else {                        
                        thread2.terminate();
                        thread3.terminate();
                        thread3.start(takereading);                                                                       
                    }
                    Thread::wait(200); 
                }
                
                if (( x >= CuMODEonoff[0] && x <= CuMODEonoff[1] ) && (y >= CuMODEonoff[2] && y <= CuMODEonoff[3])){ CuMODE = !CuMODE; }                   
                if (( x >= AgMODEonoff[0] && x <= AgMODEonoff[1] ) && (y >= AgMODEonoff[2] && y <= AgMODEonoff[3])){ AgMODE = !AgMODE; } 

                if (( x >= screenmode[0] && x <= screenmode[1] ) && (y >= screenmode[2] && y <= screenmode[3])){ 
                    screenstate = screenstate + 1;
                    if (screenstate > 2){ screenstate = 0; } 
                    Thread::wait(200);
                    EE_WriteVariable(VirtAddVarTab[7], (uint16_t)screenstate);          
                    screencycle();
                    return;                           
                }       
                                                     
  
                if (( x >= Aonoff[0] && x <= Aonoff[1] ) && (y >= Aonoff[2] && y <= Aonoff[3])){
                    Aon = !Aon;
                    if (Aon == true) {
                        p1on = true;
                        p2on = true;
                        p3on = true;
                        p4on = true;
                        p5on = true;
                        p6on = true;
                        p7on = true;                         
                    } else {
                        p1on = false;
                        p2on = false;
                        p3on = false;
                        p4on = false;
                        p5on = false;
                        p6on = false;                        
                        p7on = false;                         
                    }
                    Thread::wait(200);
                    //EE_WriteVariable(VirtAddVarTab[0], (uint16_t)p1count);  
                }     
                              
                                          
                               
          /*      sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                lcd.DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);            */
            } 
            lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
        } else {
            if (!cleared) {
                lcd.Clear(LCD_COLOR_BLACK);
              /*  sprintf((char*)text, "Touches: 0");
                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);            */
                cleared = 1;
            }
        }
        
    }
}

void screen3() {       
        while(1) {     
        if (d1count<0){d1count=0;}
        if (d2count<0){d2count=0;}
        if (d3count<0){d3count=0;}
        if (d4count<0){d4count=0;}
        if (d5count<0){d5count=0;}
        if (d6count<0){d6count=0;}                  

        


     /*   //Prime Button
        lcd.SetFont(&Font12);
        if (pcount == 0) { 
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(20,  2, 50, 15);
            for( int i = 0 ; i < 4 ; ++i ){ primeon[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(20,  2, (uint8_t *)"Prime", LEFT_MODE); 
        } else {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            touchbutt = DrawButton(20, 2, 50, 15); 
            for( int i = 0 ; i < 4 ; ++i ){ primeon[ i ] = touchbutt[ i ]; }   
            lcd.SetTextColor(LCD_COLOR_BLACK);
            sprintf((char*)nus_buffer, "%d", (int)pcount);
            lcd.DisplayStringAt(20, 2, (uint8_t *)nus_buffer, LEFT_MODE); 
        }  */

       //Screen Mode
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        touchbutt = DrawButton(230, 2, 50, 15);
        for( int i = 0 ; i < 4 ; ++i ){ screenmode[ i ] = touchbutt[ i ]; }    
        lcd.SetTextColor(LCD_COLOR_BLACK);    
        lcd.DisplayStringAt(230, 2, (uint8_t *)"Exit", LEFT_MODE);         



      //Save
        lcd.SetFont(&Font12);
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            touchbutt = DrawButton(90, 2, 50, 15);
            for( int i = 0 ; i < 4 ; ++i ){ savedate[ i ] = touchbutt[ i ]; }            
            lcd.SetTextColor(LCD_COLOR_BLACK);    
            lcd.DisplayStringAt(90, 2, (uint8_t *)"Save", LEFT_MODE); 

      
        get_time(&dt);   
        sprintf((char*)currenttime, "%02d/%02d/%04d %02d:%02d:%02d\n", dt.mm, dt.d, 2000 + dt.y, dt.h, dt.m, dt.s);      
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);   
        lcd.SetFont(&Font12);
        lcd.DisplayStringAt(0, LINE(13), (uint8_t *)currenttime, CENTER_MODE);      
      
      


        //Month
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        lcd.DisplayStringAt(10, 30, (uint8_t *)"Month", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(30,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ d1up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(30,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ d1down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)d1count);
        lcd.DisplayStringAt(30, 95, (uint8_t *)nus_buffer, LEFT_MODE);        
        


        //Day
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE); 
        lcd.DisplayStringAt(80, 30, (uint8_t *)"Day", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(100,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ d2up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(100,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ d2down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)d2count);
        lcd.DisplayStringAt(100, 95, (uint8_t *)nus_buffer, LEFT_MODE);
  


        //Year
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE); 
        lcd.DisplayStringAt(150, 30, (uint8_t *)"Year", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(170,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ d3up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(170,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ d3down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)d3count);
        lcd.DisplayStringAt(170, 95, (uint8_t *)nus_buffer, LEFT_MODE);
 




        //Hour
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        lcd.DisplayStringAt(220, 30, (uint8_t *)"Hour", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(240,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ d4up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(240,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ d4down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)d4count);
        lcd.DisplayStringAt(240, 95, (uint8_t *)nus_buffer, LEFT_MODE);
      
        
        
        //Min
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        lcd.DisplayStringAt(285, 30, (uint8_t *)"Min", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(310,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ d5up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(310,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ d5down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)d5count);
        lcd.DisplayStringAt(310, 95, (uint8_t *)nus_buffer, LEFT_MODE);        
        
    
        //Interval
        lcd.SetFont(&Font16);
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        lcd.DisplayStringAt(360, 30, (uint8_t *)"Interval(h)", LEFT_MODE); 
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_YELLOW);        
        toucharrow = DrawArrow(380,50,1,2);
        for( int i = 0 ; i < 4 ; ++i ){ d6up[ i ] = toucharrow[ i ]; }
        lcd.SetTextColor(LCD_COLOR_GREEN);
        toucharrow = DrawArrow(380,150,2,2);
        for( int i = 0 ; i < 4 ; ++i ){ d6down[ i ] = toucharrow[ i ]; }       
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);         
        sprintf((char*)nus_buffer, "%d", (int)d6count);
        lcd.DisplayStringAt(380, 95, (uint8_t *)nus_buffer, LEFT_MODE);  
    
    
     
        lcd.SetBackColor(LCD_COLOR_BLACK); 
        lcd.SetTextColor(LCD_COLOR_LIGHTBLUE); 
        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

      /*      sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE); */



            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                double touchsensativity = 0.075; //(0.055 originaly)             
                

     
 
                if (( x >= screenmode[0] && x <= screenmode[1] ) && (y >= screenmode[2] && y <= screenmode[3])){ 
                    screenstate = screenstate + 1;
                    if (screenstate > 2){ screenstate = 0; } 
                    Thread::wait(200);
                    EE_WriteVariable(VirtAddVarTab[7], (uint16_t)screenstate);          
                    screencycle();
                    return;                           
                }         
                            
                if (( x >= savedate[0] && x <= savedate[1] ) && (y >= savedate[2] && y <= savedate[3])){ setdatetime(); }   
                              
                //Month
                if (( x >= d1up[0] && x <= d1up[1] ) && (y >= d1up[2] && y <= d1up[3])){
                    d1count = d1count + touchsensativity;                                                                            
                }
                if (( x >= d1down[0] && x <= d1down[1] ) && (y >= d1down[2] && y <= d1down[3])){
                    d1count = d1count - touchsensativity;
                } 
    
                //Day
                if (( x >= d2up[0] && x <= d2up[1] ) && (y >= d2up[2] && y <= d2up[3])){
                    d2count = d2count + touchsensativity;
    
                }
                if (( x >= d2down[0] && x <= d2down[1] ) && (y >= d2down[2] && y <= d2down[3])){
                    d2count = d2count - touchsensativity;

                }               
   
                //year
                if (( x >= d3up[0] && x <= d3up[1] ) && (y >= d3up[2] && y <= d3up[3])){
                    d3count = d3count + touchsensativity;                                                       
                    
                }
                if (( x >= d3down[0] && x <= d3down[1] ) && (y >= d3down[2] && y <= d3down[3])){
                    d3count = d3count - touchsensativity;
                }
                                 
                //hour
                if (( x >= d4up[0] && x <= d4up[1] ) && (y >= d4up[2] && y <= d4up[3])){
                    d4count = d4count + touchsensativity;                                                                     
                    
                }
                if (( x >= d4down[0] && x <= d4down[1] ) && (y >= d4down[2] && y <= d4down[3])){
                    d4count = d4count - touchsensativity; 
                }

                //Min
                if (( x >= d5up[0] && x <= d5up[1] ) && (y >= d5up[2] && y <= d5up[3])){
                    d5count = d5count + touchsensativity;                                                                       
                }
                if (( x >= d5down[0] && x <= d5down[1] ) && (y >= d5down[2] && y <= d5down[3])){
                    d5count = d5count - touchsensativity;
                }   
                   
                //Interval
                if (( x >= d6up[0] && x <= d6up[1] ) && (y >= d6up[2] && y <= d6up[3])){
                    d6count = d6count + touchsensativity; 
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[8], (uint16_t)d6count);                                                                           
                }
                if (( x >= d6down[0] && x <= d6down[1] ) && (y >= d6down[2] && y <= d6down[3])){
                    d6count = d6count - touchsensativity;
                    Thread::wait(2);
                    EE_WriteVariable(VirtAddVarTab[8], (uint16_t)d6count);                           
                }                                   

                               
          /*      sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                lcd.DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);            */
            } 
            lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
        } else {
            if (!cleared) {
                lcd.Clear(LCD_COLOR_BLACK);
              /*  sprintf((char*)text, "Touches: 0");
                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);            */
                cleared = 1;
            }
        }
        
    }
}



void screencycle() {
    if (screenstate == 1) {screen();}
    if (screenstate == 0) {screen2();}  
    if (screenstate == 2) {screen3();}  
}
/////////////

int main()
{
    i2c.frequency(100000);
    set_ch(1);
    pc.baud(9600);
    LED515.write(0.0);
    LED480.write(0.0);
  /*  sd.mount();
    FILE *fp = fopen("/sd/Readings.txt", "w");
    if (fp == NULL)
    {
        fprintf(stderr, "Open error for writing!!\r\n");
        while (true) {}
    } 
        fprintf(fp, "Hello!\n");
    fprintf(fp, "Example of writing and reading of text file.\n");
    fclose(fp);    */
    //Setup LED515
    //LED515.period(-1.0f);      // 4 second period
    //LED515.write(0);      // 50% duty cycle, relative to period     
    HAL_FLASH_Unlock();
    EE_Init();
    //pump1
    EE_ReadVariable(VirtAddVarTab[0], &VarDataTab[0]);
    p1count = (double)VarDataTab[0];
    //pump2
    EE_ReadVariable(VirtAddVarTab[1], &VarDataTab[1]);
    p2count = (double)VarDataTab[1];     
    //pump3
    EE_ReadVariable(VirtAddVarTab[2], &VarDataTab[2]);
    p3count = (double)VarDataTab[2];     
    //pump4
    EE_ReadVariable(VirtAddVarTab[3], &VarDataTab[3]);
    p4count = (double)VarDataTab[3];  
    //Sole5
    EE_ReadVariable(VirtAddVarTab[4], &VarDataTab[4]);
    p5count = (double)VarDataTab[4];     
    //Pump6
    EE_ReadVariable(VirtAddVarTab[5], &VarDataTab[5]);
    p6count = (double)VarDataTab[5];           
    //Pump7
    EE_ReadVariable(VirtAddVarTab[6], &VarDataTab[6]);
    p7count = (double)VarDataTab[6]; 
    //Screen
    EE_ReadVariable(VirtAddVarTab[7], &VarDataTab[7]);
    screenstate = (int)VarDataTab[7];
    //Interval
    EE_ReadVariable(VirtAddVarTab[8], &VarDataTab[8]);
    d6count = (int)VarDataTab[8];      

    //Draw WolfMan
  /*  lcd.Clear(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"WolfMan", RIGHT_MODE); 
    lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);*/    
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.DrawBitmap(150,25,(uint8_t *)hfl);
                   
    //motors[1]->reset_device();          
    wait(2);
    
    FATFS_LinkDriver(&SD_Driver, SDPath);
    ress = f_mount(&SDFatFs, (TCHAR const*)SDPath, 0);
    Thread::wait(200);  
    if(ress!= FR_OK){ pc.printf("Failed to mount SD\n"); }
    
    saveit();
    ts.Init(lcd.GetXSize(), lcd.GetYSize());
    lcd.SetFont(&Font12);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    thread.start(screencycle); 
    sprintf((char*)cyclestep, "");
    //reprime();    
    LED515.period(1.0/10000);
    LED480.period(1.0/10000);
    thread3.start(takereading);       

    
}

