/*
 * Premier programme mbed pour carte Nucleo F303K8
 * E. DAVID
 */

#include "mbed.h"
#include "ssd1306.h"

SSD1306 OLED (I2C_SDA, I2C_SCL); // assumes default I2C address of 0x78


Ticker Timer1;

DigitalOut ledD9(PA_4);
DigitalOut ledD8(PA_5);  
DigitalOut ledD7(PA_6);  
DigitalOut ledD6(PA_7);

AnalogIn adc_A0(PA_0);

DigitalIn  SW4_1(PA_1);
DigitalIn  SW4_2(PA_3);

InterruptIn SW1(PB_4, PullUp); 

Serial pc(USBTX, USBRX);

char counter = 0;


void Timer_Envoi() {
    pc.printf("Envoi Timer \n");
}

void AppuiSW1() {
        ledD6 = 0;
        ledD7 = 0;
}

int main()
{   
    pc.baud(115200);
    pc.printf("main()\n");
    
    // Utilisation d'un timer : appel de la fonction Timer_Envoi() toutes les 2s
    Timer1.attach(&Timer_Envoi, 2.0);
    
    OLED.speed (SSD1306::Medium);  // set working frequency
    OLED.init();                   // initialize SSD1306
    OLED.cls();                    // clear frame buffer
    OLED.locate (0,0);             // set text cursor to line 3, column 1
    OLED.printf ("GEII"); // print to frame buffer
    OLED.redraw();                 // updates actual display transferring frame buffer over I2C bus 
    
    ledD9 = 1;
    ledD8 = 1; 
    
    // Validation de l'interruption sur un front descendant de SW1
    // appel de la routine d'interruption AppuiSW1()
    SW1.fall(&AppuiSW1); 
    
    while (1) {  
        OLED.locate (2,0);             
        OLED.printf("ADC A0=%2.1f", (adc_A0.read()*100));      
        OLED.redraw();  
        ledD6 = !ledD6;
        wait(2.0);
    }
}
