/*
 * Programme principal TP2 - Bus CAN
 */

#if !DEVICE_CAN
#error [NOT_SUPPORTED] CAN not supported for this target
#endif

#include "mbed.h"
#include "ssd1306.h"

SSD1306 OLED (I2C_SDA, I2C_SCL, 0x78); // assumes default I2C address of 0x78

DigitalOut  ledD9(PA_4);
DigitalOut  ledD8(PA_5);   // Attention, désouder SB16&SB18 si utilisation I2c
DigitalOut  ledD7(PA_6);   
DigitalOut  ledD6(PA_7);

DigitalIn   SW4_1(PA_1);
DigitalIn   SW4_0(PA_3);
DigitalIn   SW1(PB_4, PullUp); 
DigitalIn   SW2(PB_5, PullUp); 

InterruptIn SW3(PA_8, PullUp); 

AnalogIn adc_RV1(PA_0);

CAN can(PA_11, PA_12);
Serial pc(USBTX, USBRX);

int value_SW4;              // valeur 0,1,2,3 

char Reset[6] = "Reset";
char Donnees[12]="";
char Data[5] = "GEII";
char DataArbitrage[5] = "K1bb";
int Nb_messT = 0;
int Nb_messR = 0;


int detectionFrontSW1(void) {
    int frontDescendant = 0;
    static int etatPrecedent1=1;
    int bp1 = SW1.read();
    if(bp1!=etatPrecedent1 && !bp1)
        frontDescendant = 1;
    etatPrecedent1= bp1;
    return frontDescendant;
}

int detectionFrontSW2(void) {
    int frontDescendant = 0;
    static int etatPrecedent2=1;
    int bp2 = SW2.read();
    if(bp2!=etatPrecedent2 && !bp2)
        frontDescendant = 1;
    etatPrecedent2= bp2;
    return frontDescendant;
}

/* Test Arbitrage */
void AppuiSW3() {
   // if (value_SW4 == 3) {
       if (can.write(CANMessage(60, DataArbitrage, 5 , CANData, CANStandard)))  { // Rmq : tableau = pointeur
            ledD8 = !ledD8;
            Nb_messT++; 
        }
   // }   
}


int LectureSW4(){
    int ETAT;
    int value_SW4_0 = SW4_0.read();
    int value_SW4_1 = SW4_1.read();
    
    if (value_SW4_1 == 1) {
        if (value_SW4_0 == 1)
            ETAT = 3;
        else
            ETAT = 2;
    }
    else {
        if (value_SW4_0 == 1)
            ETAT = 1;
        else
            ETAT = 0;       
    }
    return ETAT;
}

int main() {
    
    //uint8_t receivedMessage[8];
    
    pc.baud(115200);
    pc.printf("Affichage serie Carte 1 \n");
    
    can.frequency(500000); 
    
    CANMessage msg;
    //unsigned char REC, TEC ;

    ledD6 = 1; ledD7 = 1; ledD8 = 1; ledD9 = 1;
    
    OLED.speed (SSD1306::Medium);  // set working frequency
    OLED.init();                   // initialize SSD1306
    OLED.cls();                    // clear frame buffer

    SW3.fall(&AppuiSW3);            // SW3 sous it

    
    OLED.locate (0,0);
    OLED.printf ("NbRx = 0");
    OLED.locate (1,0);
    OLED.printf ("NbTx = 0");  

    while(1) 
    {     
        value_SW4 = LectureSW4();
        
        if (detectionFrontSW1())
        {
            if (value_SW4 == 0) {
                if (can.write(CANMessage(1975, Data, 5 , CANData, CANStandard))) { // Rmq : tableau = pointeur
                    ledD6 = !ledD6;
                    Nb_messT++;
                }
            }          
        } 
        if (detectionFrontSW2())
        {
            if (value_SW4 == 0) {
                if (can.write(CANMessage(1975, CANStandard))) { // Remote frame
                    ledD7 = !ledD7;
                    Nb_messT++;
                }
            }          
        } 
        
        if (can.read(msg)) {
            Nb_messR++;
            ledD9 = !ledD9;          
            for (int i =0; i < msg.len; i++)
                Donnees[i] = msg.data[i]; 
            pc.printf("ID = 0x%.3x\r\n", msg.id); //ID sous forme 0x suivi de l'id
            pc.printf("Length = %d\r\n", msg.len);
            pc.printf("Boucle envoi CAN rderrors : %d, CAN tderrors : %d\n", can.rderror(), can.tderror());   
            //REC = can.rderror();              
        }

        OLED.locate (0,0);
        OLED.printf ("NbRx = %d", Nb_messR);  
        OLED.locate (1,0);
        OLED.printf ("NbTx = %d", Nb_messT); 
        OLED.locate (3,0);
        OLED.printf ("Message recu ");
        OLED.locate (4,0);
        OLED.printf ("=> ");
        OLED.puts(Donnees);
        OLED.locate (6,0);          
        OLED.printf("Valeur REC=%u", can.rderror());
        OLED.locate (7,0);          
        OLED.printf("Valeur TEC=%u", can.tderror());        
        OLED.redraw();  
        wait(0.2);
    }
}