/*
 * Copyright (c) 2017-2020 Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 */

#if !DEVICE_CAN
#error [NOT_SUPPORTED] CAN not supported for this target
#endif


#include "mbed.h"
#include "ssd1306.h"

SSD1306 OLED (I2C_SDA, I2C_SCL); // assumes default I2C address of 0x78


//Ticker ticker;

DigitalOut ledD9(PA_4);
DigitalOut ledD8(PA_5);   // NON, désouder SB16 si utilisation I2c
DigitalOut ledD7(PA_6);   // NON, désouder SB18 si utilisation I2c
DigitalOut ledD6(PA_7);

DigitalIn   SW4_1(PA_1);
DigitalIn   SW4_0(PA_3);
DigitalIn   SW1(PB_4, PullUp); 
DigitalIn   SW2(PB_5, PullUp); 
//DigitalIn   SW3(PA_8, PullUp); 

//InterruptIn SW1(PB_4, PullUp); 
//InterruptIn SW2(PB_5, PullUp); 
InterruptIn SW3(PA_8, PullUp); 

/** The constructor takes in RX, and TX pin respectively.
  * These pins, for this example, are defined in mbed_app.json
  */
//CAN can1(MBED_CONF_APP_CAN1_RD, MBED_CONF_APP_CAN1_TD);

CAN can(PA_11, PA_12);
//Serial pc(USBTX, USBRX);

char counter = 123;
char Carte2[] = "K2  ";
char Carte2bb[] = "K2bb";
int Nb_messT = 0;
int value_SW4=0;

int detectionFrontSW1(void) {
    int frontDescendant = 0;
    static int etatPrecedent1=1;
    int bp = SW1.read();
    if(bp!=etatPrecedent1 && !bp)
        frontDescendant = 1;
    etatPrecedent1= bp;
    return frontDescendant;
}

int detectionFrontSW2(void) {
    int frontDescendant = 0;
    static int etatPrecedent1=1;
    int bp = SW2.read();
    if(bp!=etatPrecedent1 && !bp)
        frontDescendant = 1;
    etatPrecedent1= bp;
    return frontDescendant;
}

/*
int detectionFrontSW3(void) {
    int frontDescendant = 0;
    static int etatPrecedent1=1;
    int bp = SW3.read();
    if(bp!=etatPrecedent1 && !bp)
        frontDescendant = 1;
    etatPrecedent1= bp;
    return frontDescendant;
}
*/

/* Test Arbitrage */
void AppuiSW3() {
    if (value_SW4 == 3) {
        if (can.write(CANMessage(60, Carte2bb, 5 , CANData, CANStandard)))  { // Rmq : tableau = pointeur
            ledD8 = !ledD8;
            Nb_messT++; 
        }
    }
    if (value_SW4 == 2) {
        if (can.write(CANMessage(48, Carte2bb, 5 , CANData, CANStandard)))  { // Rmq : tableau = pointeur
            ledD8 = !ledD8;
            Nb_messT++; 
        }
    }     
}


int LectureSW4(){
    int ETAT;
    int value_SW4_0 = SW4_0.read();
    int value_SW4_1 = SW4_1.read();
    
    if (value_SW4_1 == 1) {
        if (value_SW4_0 == 1)
            ETAT = 3;
        else
            ETAT = 2;
    }
    else {
        if (value_SW4_0 == 1)
            ETAT = 1;
        else
            ETAT = 0;       
    }
    return ETAT;
}


int main()
{
    //pc.baud(115200);
    //pc.printf("main()\n");
    
    can.frequency(500000); 
    CANMessage msg;
    
    char Donnees[8]="";
    static int Nb_messR = 0;
    
    ledD6 = 1; ledD7 = 1; ledD8 = 1; ledD9 = 1;
    
    OLED.speed(SSD1306::Medium);  // set working frequency
    OLED.init();                   // initialize SSD1306
    OLED.cls();                    // clear frame buffer

    OLED.locate (0,0);
    OLED.printf ("NbRx = 0");
    OLED.locate (1,0);
    OLED.printf ("NbTx = 0");  

    SW3.fall(&AppuiSW3);

    while (1) {
        //pc.printf("Reception message \n");
        value_SW4 = LectureSW4();
        
        if (detectionFrontSW1())
        {
            if (value_SW4 == 0) {
                if (can.write(CANMessage(2021, Carte2, 5 , CANData, CANStandard))) { // Rmq : tableau = pointeur
                    ledD6 = !ledD6;
                    Nb_messT++;
                }
            }          
        } 
        /*
        if (detectionFrontSW2())
        {
            if (value_SW4 == 0) {
                if (can.write(CANMessage(2021, CANStandard))) { // Remote frame
                    ledD7 = !ledD7;
                    Nb_messT++;
                }
            }          
        }     
        */   
        /*
        if (detectionFrontSW3())
        {
            if (value_SW4 == 3) {
                if (can.write(CANMessage(60, Carte2bb, 5 , CANData, CANStandard)))  { // Rmq : tableau = pointeur
                    ledD8 = !ledD8;
                    Nb_messT++; 
                }
            }
            if (value_SW4 == 2) {
                if (can.write(CANMessage(48, Carte2bb, 5 , CANData, CANStandard)))  { // Rmq : tableau = pointeur
                    ledD8 = !ledD8;
                    Nb_messT++; 
                }
            }                
        }          
        */
      
        if (can.read(msg)) {
            Nb_messR++;
            ledD9 = !ledD9;
            
            for (int i =0; i < msg.len; i++)
                Donnees[i] = msg.data[i];

            //pc.printf("ID = 0x%.3x\r\n", msg.id); //ID sous forme 0x suivi de l'id
            //pc.printf("Length = %d\r\n", msg.len);
            //pc.printf("CAN rderrors : %d, CAN tderrors : %d\n", can.rderror(), can.tderror());
            
        }
        OLED.locate (0,0);
        OLED.printf ("NbRx = %d", Nb_messR);  
        OLED.locate (1,0);
        OLED.printf ("NbTx = %d", Nb_messT); 
        OLED.locate (3,0);
        OLED.printf ("Message recu ");
        OLED.locate (4,0);
        OLED.printf ("=> ");
        OLED.puts(Donnees);
        OLED.locate (6,0);          
        OLED.printf("Valeur REC=%d", can.rderror());
        OLED.locate (7,0);          
        OLED.printf("Valeur TEC=%d", can.tderror());        
        OLED.redraw();  
        wait(0.2);
    }
}


/* Envoi d'une trame de requete */
/*
void AppuiSW2() {
  if (can.write(CANMessage(1620, CANStandard ))) {
    ledD7 = !ledD7;
  } 
}
*/
/* Reset controleur après court-circuit */
/*
void AppuiSW3() {
  if (can.write(CANMessage(2021, Reset, 6 , CANData, CANStandard))) // Rmq : tableau = pointeur
    ledD8 = !ledD8;
  else
    can.reset(); 
}
*/
/* Reset controleur après court-circuit */
/*
void AppuiSW3() {
    can.reset(); 
    OLED.cls();
    OLED.locate (0,0);             // set text cursor to line 3, column 1
    OLED.printf ("GEII - Bus CAN"); // print to frame buffer
    OLED.locate (2,0);             // set text cursor to line 3, column 1
    OLED.printf ("SW1"); // print to frame buffer  
    OLED.locate (3,0);             // set text cursor to line 3, column 1
    OLED.printf ("Envoi trame"); // print to frame buffer    
    OLED.redraw();  
}
*/
/*
char *conversionIntChaine(int longueurChaine, int Valeur_int, char *ChaineAffichage)
{
    while (longueurChaine >= 0)
    {
        ChaineAffichage[longueurChaine] = (Valeur_int % 10) + 48;
        Valeur_int /= 10;
        longueurChaine--;
    }
    return (ChaineAffichage);
}
*/

    /*
    OLED.locate (0,0);             // set text cursor to line 3, column 1
    OLED.printf ("GEII - Bus CAN"); // print to frame buffer
    OLED.locate (2,0);             // set text cursor to line 3, column 1
    OLED.printf ("SW1"); // print to frame buffer  
    OLED.locate (3,0);             // set text cursor to line 3, column 1
    OLED.printf ("Envoi trame"); // print to frame buffer    
    OLED.redraw();                 
    */

/*
char *
itoa (int n)
{

    char *a = malloc (long_int (n) + 1);
    int i;
    for (i = 0; n > 0; i++)
    {
        a[i] = n % 10 + 48;
        n = n / 10;
    }
    a[i + 1] = '\0';
    return retourne (a);
}

char *create_str(int len, int n, int neg, char *str)
{
while (len >= 0)
{
str[len] = (n % 10) + 48;
n /= 10;
len--;
}
if (neg < 0)
str[0] = '-';
return (str);
}
*/
