/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

//FUNCTION THAT DRAWS A MANUAL WINDOW
/***************************************************/
void createWindow(AXIS x1, AXIS y1, AXIS x2, AXIS y2, COLOUR top, COLOUR text, char *name){
  AXIS aux;
  NUMBEROFBYTES charsPrinted;
  
  lcd.setTextSize(FONT3);
  lcd.drawRectangle(x1,y1,x2,y2,0xDEFB,FILL); //draw grey 0xDEFB back
  aux = ((y2-y1) * 20) / 100;
  if(aux<10) aux=10;
  lcd.drawGradientRect(x1,y1,x2-1,y1+aux,top,WHITE,VERTICAL); //draw top
  lcd.drawLine(x1,y1,x2,y1,WHITE);
  lcd.drawLine(x1,y2,x2,y2,BLACK);  
  lcd.drawLine(x1,y1,x1,y2,WHITE);  
  lcd.drawLine(x2,y1,x2,y2,BLACK);  
  lcd.string(x1+5,y1+5,x2,y2,name,&charsPrinted);
}

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  
  initializeSmartGPU2();             //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD7);             //set a fast baud! for fast drawing
  
  lcd.setEraseBackColour(GREEN); //set the erase background colour  

  while(1){//forever
    //erase screen
    lcd.erase();
    //draw the manual window 
    createWindow(20,20,300,200,BLUE,WHITE,"window 1");
    //wait
    wait_ms(3000);
    
    //erase screen
    lcd.erase();    
    //draw the internal SmartGPU2 object window     
    lcd.objWindow(20,20,300,200,FONT2,SELECTEDGRAY,"window 1");
    //wait
    wait_ms(3000);
  }
}
