/**************************************************************************************/
/*SMARTGPU intelligent embedded graphics processor unit
 those examples are for use the SMARTGPU with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/#/desarrollo/4554296549
 
 This example requires pre-loaded content to the micro SD card, images and text files!
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2011 */
/**************************************************************************************/
/**************************************************************************************/
 
#include "mbed.h"
#include "SMARTGPU.h"

SMARTGPU lcd(p13,p14,p15);        //(TX,RX,Reset);

char message[]="Hello World";     //an array containing some text for later use

int main() { 
  lcd.reset();                    //physically reset SMARTGPU
  lcd.start();                    //initialize the SMARTGPU processor
  
  while (1) {
    wait_ms(1000);                                                                                   //wait some time 
    lcd.drawLine(50,50,150,200,WHITE);                                                               //draw a line
    wait_ms(1000);
    lcd.drawRectangle(10,10,200,180,RED,UNFILL);                                                     //draw a rectangle
    wait_ms(1000);
    lcd.drawCircle(160,120,50,GREEN,UNFILL);                                                         //draw a circle
    wait_ms(1000);
    lcd.drawTriangle(15,15,200,210,180,70,BLUE,UNFILL);                                              //draw a triangle
    wait_ms(1000);                                                                                 
    lcd.string(10,10,300,220,YELLOW,FONT3,TRANS,"This is the string test for SMARTGPU lcd320x240");  //write a string on the screen
    wait_ms(1000);    
    lcd.string(10,60,300,220,GREEN,FONT3,TRANS,message);                                             //write the string previously created (char message[]="Hello World";)
    wait_ms(1000);
    lcd.putLetter(100,100,MAGENTA,FONT3,TRANS,'E');                                                  //write a single letter 'E'
    wait_ms(1000);
    lcd.putPixel(300,200,CYAN);                                                                      //draw a pixel
    wait_ms(3000);
    lcd.imageSD(0,0,"hydra320");                                                                     //call the image "hydra320.bmp" previously stored on the micro SD card
    wait_ms(1000);    
    lcd.stringSD(5,50,300,230,MAGENTA,FONT3,TRANS,BEGINNING,ALLCONTENTS,"text1");                    //call the text file "text1.txt" previously stored on the micro SD card
    wait_ms(1000);   
    lcd.drawRectangle(10,10,200,180,RED,FILL);                                                       //draw a rectangle
    wait_ms(1000);
    lcd.drawCircle(160,120,50,GREEN,FILL);                                                           //draw a circle
    wait_ms(1000);
    lcd.drawTriangle(15,15,200,210,180,70,BLUE,FILL);                                                //draw a triangle 
    wait_ms(3000);
    lcd.erase();                                                                                     //erase screen
  }
}