/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"


/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  POINT p1, p2, p3;
  COLOUR colour;
  FILLGEOM fill;
      
  initializeSmartGPU2();        //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD7);        //set a fast baud! for fast drawing
  
  while(1){//forever
    p1.x= (rand()%LCD_WIDTH);   //get a random number 0-319
    p1.y= (rand()%LCD_HEIGHT);  //get a random number 0-239
    p2.x= (rand()%LCD_WIDTH);   //get a random number 0-319
    p2.y= (rand()%LCD_HEIGHT);  //get a random number 0-239
    p3.x= (rand()%LCD_WIDTH);   //get a random number 0-319
    p3.y= (rand()%LCD_HEIGHT);  //get a random number 0-239
    colour=  (rand()%65536);    //get a random number 0-65535
    fill=(FILLGEOM)(rand()%2);  //get a random number 0-1
    
    //draw the triangle
    if(lcd.drawTriangle(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, colour,fill) != 'O'){ //draw random triangles
      while(1);                    //loop forever if different than 'O'--OK        
    }
  }
}