/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

#define PENSIZE 3         //size of the drawing pen 

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
    POINT point;
    NUMBEROFBYTES bytes;
    
    initializeSmartGPU2();
    lcd.baudChange(BAUD6);                      // Set a fast baud!, always that we use touch functions is recommended to use fast baud rates

    //front cover
    lcd.setTextColour(YELLOW);
    lcd.setTextSize(FONT4);    
    lcd.string(LCD_WIDTH/8,LCD_HEIGHT/4,MAX_X_LANDSCAPE,MAX_Y_LANDSCAPE,"Mini Paint",&bytes);        
    lcd.setTextColour(BLUE);
    lcd.setTextSize(FONT3);        
    lcd.string(LCD_WIDTH/6,LCD_HEIGHT/2,MAX_X_LANDSCAPE,MAX_Y_LANDSCAPE,"Touch on corner \nto erase screen",&bytes);
    lcd.setTextColour(MAGENTA);
    lcd.setTextSize(FONT2);        
    lcd.string(LCD_WIDTH/8,MAX_Y_LANDSCAPE-(LCD_HEIGHT/3),MAX_X_LANDSCAPE,MAX_Y_LANDSCAPE,"Touch screen to begin",&bytes);
    
    while(lcd.touchScreen(&point)==INVALID);                    // Wait for a touch on the screen to start
    lcd.erase();
    lcd.objButton(MAX_X_LANDSCAPE-40,0,MAX_X_LANDSCAPE,25,DESELECTED,"clear");
    wait_ms(500);
    
    while(1){                                                   // Loop forever
      if(lcd.touchScreen(&point)==VALID){                       // If we receive a touch on the screen
        if((point.x > (MAX_X_LANDSCAPE-40)) && (point.y < 25)){ // if touch on clear button
          lcd.erase();
          lcd.objButton(MAX_X_LANDSCAPE-40,0,MAX_X_LANDSCAPE,25,DESELECTED,"clear");
          wait_ms(200);
        }else{                                                  // touch anywhere on the screen
          lcd.drawCircle(point.x,point.y,PENSIZE,YELLOW,FILL);  // Draw circle on touched coordinates          
        }
      }
    }  
}