/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

//we define a new structure of INT instead of UNSIGNED INT
typedef struct {
    int x; //X axis
    int y; //Y axis
} POINTINT;    //to create a point with point.x and point.y variable

#define CLOCKBODYCOLOUR  BLACK        //colour for the body clock
#define CLOCKEDGECOLOUR  GREEN        //colour for the edge of the clock
#define SECCOL           YELLOW       //seconds hand colour
#define MINCOL           MAGENTA      //minutes hand colour
#define HOURCOL          RED          //hours hand colour
#define HALFX            LCD_WIDTH/2  //this point represent the x center of the clock where math is done
#define HALFY            LCD_HEIGHT/2 //this point represent the y center of the clock where math is done

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  POINTINT secP,minsP,hourP;
  AXIS updatedXPosition;
  int secs=15;
  int mins=45;
  int hours=2;
  int angleH,angleM,angleS;
  int handHour=75;//hand size
  int handMin=85;//hand size
  int handSec=95;//hand size  
  
  initializeSmartGPU2();             //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD7);             //set a fast baud! for fast drawing
  lcd.drawCircle(HALFX,HALFY,HALFY-5,CLOCKBODYCOLOUR,FILL);    //draw clock body
  lcd.drawCircle(HALFX,HALFY,HALFY-5,CLOCKEDGECOLOUR,UNFILL);  //draw clock edge
  
  //config strings
  lcd.setTextColour(CLOCKEDGECOLOUR);
  lcd.setTextSize(FONT5);
  lcd.setTextBackFill(TRANS);
  
 while(1){
  //Do some Math to get the second point of the clock hands. (first point is always the center of the clock)
  angleS=secs*6;                           //get the current seconds in angle form, a circle have 360 degrees divided by 60 seconds = 6, then we multiply the 6 by the current seconds to get current angle
  secP.x=((sin((angleS*3.14)/180)) * handSec);   //get X component of the second's hand
  secP.y=((cos((angleS*3.14)/180)) * handSec);   //get Y component of the second's hand
  angleM=mins*6;                           //get the current minutes in angle form, a circle have 360 degrees divided by 60 minutes = 6, then we multiply the 6 by the current minutes to get current angle
  minsP.x=((sin((angleM*3.14)/180)) * handMin);   //get X component of the minutes's hand
  minsP.y=((cos((angleM*3.14)/180)) * handMin);   //get Y component of the minutes's hand 
  angleH=hours*30;                         //get the current hours in angle form, a circle have 360 degrees divided by 12 hours = 30, then we multiply the 30 by the current hours to get current angle
  hourP.x=((sin((angleH*3.14)/180)) * handHour);  //get X component of the hours's hand
  hourP.y=((cos((angleH*3.14)/180)) * handHour);  //get Y component of the hours's hand
    
  lcd.putLetter(HALFX-20,22,'1',&updatedXPosition);          //Draw the 1                                 
  lcd.putLetter(updatedXPosition,22,'2',&updatedXPosition);  //Draw the 2  
  
  //Draw current time hands  
  lcd.drawLine(HALFX,HALFY,HALFX+minsP.x,HALFY-minsP.y,MINCOL);  // Draw the minutes hand, first point is the center of the clock, and the second is the point obtained by doing math
  lcd.drawLine(HALFX,HALFY,HALFX+hourP.x,HALFY-hourP.y,HOURCOL); // Draw the hours hand, first point is the center of the clock, and the second is the point obtained by doing math
  lcd.drawLine(HALFX,HALFY,HALFX+secP.x,HALFY-secP.y,SECCOL);    // Draw the seconds hand, first point is the center of the clock, and the second is the point obtained by doing math
  lcd.drawCircle(HALFX,HALFY,5,SECCOL,FILL);                   // Draw the center of the second's hand
  
  wait_ms(1000);                                  // wait for one second delay (we dont need to explain why we're waiting one second, right?)

  secs++;                                         // increase seconds
  if(secs==60){                                   // if we reach 60 seconds
    mins++;                                       // increase the minutes
    if(mins==60){                                 // if we reach 60 minutes
      hours++;                                    // increase the minutes
      if(hours==12){                              // if we reach 12 hours
        hours=0;                                  // clear hours
      } 
      mins=0;                                     // clear minutes
    }            
    secs=0;                                       // clear seconds
  }                      
 
  //Erase all hands         
  lcd.drawLine(HALFX,HALFY,HALFX+secP.x,HALFY-secP.y,CLOCKBODYCOLOUR);   // Erase Second's hand
  lcd.drawLine(HALFX,HALFY,HALFX+minsP.x,HALFY-minsP.y,CLOCKBODYCOLOUR); // Erase Minute's hand
  lcd.drawLine(HALFX,HALFY,HALFX+hourP.x,HALFY-hourP.y,CLOCKBODYCOLOUR); // Erase Hour's hand            
 }
}