/**************************************************************************************/
/*SMARTWAV intelligent embedded sWav processor unit
 those examples are for use the SMARTWAV with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://vizictechnologies.com/#/smart-wav/4559021187
 
 This example requires pre-loaded content to the micro SD card, sWav .WAV files!
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2012 */
/**************************************************************************************/
/**************************************************************************************/

/**************************************************************************************/
//This demo require a mbed connection to a PC with an Hyperterminal sesion opened at 9600bps/1 stop bits/ no parity/flow control none
/**************************************************************************************/
 
#include "mbed.h"
#include "SMARTWAV.h"

SMARTWAV sWav(p13,p14,p15);        //(TX,RX,Reset);

Serial pc(USBTX, USBRX);

//Global Variables
char playList[500];     //an array for storing the retrieved list of Audio files
char dirList[500];     //an array for storing the retrieved list of Folders/Dirs


/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
int main() { 
  char name[9]={0}; 
    
  sWav.reset();                    //physically reset SMARTWAV
  
  pc.printf("Welcome to the SmartWAV PC demo! getting microSD contents...\n\r\n\r");
  
  wait_ms(50);
  sWav.getFolderList(dirList); 
  wait_ms(50);
  sWav.getFileList(playList);

  pc.printf("Folders/Dirs:\n\r"); 
  pc.printf(dirList); 
  pc.printf("\n\r\n\r"); 
  pc.printf("Audio Files/Songs:\n\r"); 
  pc.printf(playList);
  pc.printf("\n\r\n\r");   
  pc.printf("Press 'T' play, 'P' pause/resume, 'R' rewind, 'N' next song, 'S' stop:(case sensitive)\n\r\n\r");  
  
  while (1){
    switch(pc.getc()){
        case 'T':
            sWav.playTracks();
        break;

        case 'P':
            sWav.pausePlay(); 
            wait_ms(500);
            while(pc.getc()!='P'); //while no 'P' character is pressed again       
            sWav.pausePlay();             
        break;
        
        case 'R':
            sWav.rewindTrack();                
        break;
        
        case 'N':
            sWav.nextTrack();                
        break;
        
        case 'S':
            sWav.stopTrack();                
        break;
                                        
        default:
        break;
    }
    wait_ms(500);
    pc.printf("Current Song Name:");             
    sWav.getFileName(name);
    pc.printf(name);
    pc.printf("  play Status:");             
    if(sWav.getStatus()){
        pc.printf("Active        ");             
    }else{
        pc.printf("non Active    ");                 
    }
    pc.printf("\r");                     
    wait_ms(500);
  }
}