/*********************************************************
VIZIC TECHNOLOGIES. COPYRIGHT 2012.
THE DATASHEETS, SOFTWARE AND LIBRARIES ARE PROVIDED "AS IS." 
VIZIC EXPRESSLY DISCLAIM ANY WARRANTY OF ANY KIND, WHETHER 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
OR NONINFRINGEMENT. IN NO EVENT SHALL VIZIC BE LIABLE FOR 
ANY INCIDENTAL, SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, 
LOST PROFITS OR LOST DATA, HARM TO YOUR EQUIPMENT, COST OF 
PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, 
ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO 
ANY DEFENCE THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION,
OR OTHER SIMILAR COSTS.
*********************************************************/

/********************************************************
 IMPORTANT : This library is created for the mbed Microcontroller Software IDE
********************************************************/

#ifndef SMARTWAV_H
#define SMARTWAV_H

#include <mbed.h>


//******************LIBRARY DEFINED PINS (don't modify)*******************//
//General definitions
#define audioOFF 0
#define audioON 1
#define RESET 13
#define TX 1
#define RX 0
#define DISABLE 0
#define ENABLE 1
#define HALFX 0
#define ONEX 1
#define ONEPOINTFIVEX 2
#define TWOX 3
#define MAX 0xFF
#define MED 0xE0
#define MIN 0x00 


//**************************************************************************
// class SMARTWAV SMARTWAV.h
// This is the main class. It shoud be used like this : SMARTWAV audio(p13,p14,p15);

class SMARTWAV{
    
public:
    
    SMARTWAV(PinName TXPin, PinName RXPin, PinName resetPin);
    
    void init();

    void reset();
    
    unsigned char sleep();  

    unsigned char getStatus();

    unsigned char playTracks();
	
	unsigned char pausePlay();
	
	unsigned char rewindTrack();
	
	unsigned char nextTrack();
    
    unsigned char playTrackName(char[]);
	
	unsigned char stopTrack();
	
	unsigned char continuousPlay(unsigned char);	
	
	unsigned char volume(unsigned char);	
	
	unsigned char setFolder(char[]);
    
    unsigned char getFileName(char[]);
	
	unsigned char getFolderName(char[]);
	
	unsigned char getFileList(char[]);
	
	unsigned char getFolderList(char[]);
	
	unsigned char playSpeed(unsigned char);
	
    protected :

    Serial     _serialSMARTWAV;
    DigitalOut _resetPin;
    
};
typedef unsigned char BYTE;

#endif
