 
#include "mbed.h"
#include "SMARTGPU.h"
        
// SMART GPU DEFAULT BAUD RATE: 9600bps
//It shoud be used like this : SMARTGPU lcd(p13,p14,p15); for serial communication with SMARTGPU
SMARTGPU::SMARTGPU(PinName TXPin, PinName RXPin, PinName resetPin): _serialSMARTGPU(TXPin,RXPin), _resetPin(resetPin){    
    init();
}

/********** high level commands, for the user! */
void SMARTGPU::init(){         //configure the mbed for SMARTGPU board    
    _serialSMARTGPU.baud(9600);
    _resetPin=1;               //set the pin to 3.3v to avoid reset 
}
 
void SMARTGPU::reset(){        //Reset the SMARTGPU board
    _resetPin=0;               //set the pin to GND to reset 
    wait_ms(500);
    _resetPin=1;               //set the pin to 3.3v to end reset
    wait_ms(500);    
}

unsigned char SMARTGPU::start(){           //Init the SMARTGPU
  wait_ms(500); 
  _serialSMARTGPU.putc('U');  
  wait_ms(1000);
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::erase(){          //Erase the SMARTGPU screen
  _serialSMARTGPU.putc('E');  
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::sleep(unsigned char mode){       //Send SMARTGPU to sleep mode
  _serialSMARTGPU.putc('Z'); 
  _serialSMARTGPU.putc(mode);
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::orientation(unsigned char side){       //Change display orientation
  _serialSMARTGPU.putc('O'); 
  _serialSMARTGPU.putc(side);
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::bright(unsigned char val){       //Change display brightness
  _serialSMARTGPU.putc('V'); 
  _serialSMARTGPU.putc(val); 
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::baudChange(unsigned long val){       //Change baud rate of arduino and SMARTGPU board
  unsigned char aux;
 
  switch(val){
    case 9600:
      aux=0;
    break;
    case 19200:
      aux=1;
    break;
    case 57600:
      aux=2;
    break;
    case 115200:
      aux=3;
    break;
    case 256000:
      aux=4;
    break;    
    case 500000:
      aux=5;
    break;
    case 1000000:
      aux=6;
    break;
    case 2000000:
      aux=7;
    break;
    default:
      return 'F';
  } 
  _serialSMARTGPU.putc('X');
  _serialSMARTGPU.putc(aux);  
  aux=_serialSMARTGPU.getc();
  if(aux=='O'){
    wait_ms(150);
    _serialSMARTGPU.baud(val);
    wait_ms(200);
    return _serialSMARTGPU.getc();
  }else{
    return aux;
  }
}

unsigned char SMARTGPU::digitalOut(unsigned char number, unsigned char val ){       //Set Digital out pins to a logic value
  _serialSMARTGPU.putc('D'); 
  _serialSMARTGPU.putc(number);
  _serialSMARTGPU.putc(val); 
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::setScreenBackground(int colour){       //Change the default screen background colour for erase function
  _serialSMARTGPU.putc('B'); 
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);  
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::setTextBackground(int colour){       //Set the default text background colour for letters and strings
  _serialSMARTGPU.putc('A'); 
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);  
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::memoryRead(int x1, int y1, int x2, int y2, char buffer[]){ //Read the internal memory of the SMARTGPU, This command returns 24bit pixels (3 bytes)
  unsigned int i,j,k=0;
  
  _serialSMARTGPU.putc('M'); 
  _serialSMARTGPU.putc(x1>>8); 
  _serialSMARTGPU.putc(x1);
  _serialSMARTGPU.putc(y1>>8);
  _serialSMARTGPU.putc(y1);
  _serialSMARTGPU.putc(x2>>8); 
  _serialSMARTGPU.putc(x2);
  _serialSMARTGPU.putc(y2>>8);
  _serialSMARTGPU.putc(y2); 

  //receive all the pixels
  for(j=0;j<=(y2-y1);j++){
    for(i=0;i<=(x2-x1);i++){
        buffer[k]=_serialSMARTGPU.getc(); //Red
        k++;
        buffer[k]=_serialSMARTGPU.getc(); //Green
        k++;
        buffer[k]=_serialSMARTGPU.getc(); //Blue
        k++;
    }    
  } 
  return _serialSMARTGPU.getc();  
}

unsigned char SMARTGPU::putPixel(int x, int y, int colour){       //Draw a pixel on the screen
  _serialSMARTGPU.putc('P'); 
  _serialSMARTGPU.putc(x>>8); 
  _serialSMARTGPU.putc(x);
  _serialSMARTGPU.putc(y>>8);
  _serialSMARTGPU.putc(y);
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::drawLine(int x1, int y1, int x2, int y2, int colour){       //Draw a line on the screen
  _serialSMARTGPU.putc('L'); 
  _serialSMARTGPU.putc(x1>>8); 
  _serialSMARTGPU.putc(x1);
  _serialSMARTGPU.putc(y1>>8);
  _serialSMARTGPU.putc(y1);
  _serialSMARTGPU.putc(x2>>8); 
  _serialSMARTGPU.putc(x2);
  _serialSMARTGPU.putc(y2>>8);
  _serialSMARTGPU.putc(y2);  
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::drawRectangle(int x1, int y1, int x2, int y2, int colour, unsigned char fill){       //Draw a rectangle on the screen
  _serialSMARTGPU.putc('R'); 
  _serialSMARTGPU.putc(x1>>8); 
  _serialSMARTGPU.putc(x1);
  _serialSMARTGPU.putc(y1>>8);
  _serialSMARTGPU.putc(y1);
  _serialSMARTGPU.putc(x2>>8); 
  _serialSMARTGPU.putc(x2);
  _serialSMARTGPU.putc(y2>>8);
  _serialSMARTGPU.putc(y2);  
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);
  _serialSMARTGPU.putc(fill);   
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int colour, unsigned char fill){       //Draw a triangle on the screen
  _serialSMARTGPU.putc('T'); 
  _serialSMARTGPU.putc(x1>>8); 
  _serialSMARTGPU.putc(x1);
  _serialSMARTGPU.putc(y1>>8);
  _serialSMARTGPU.putc(y1);
  _serialSMARTGPU.putc(x2>>8); 
  _serialSMARTGPU.putc(x2);
  _serialSMARTGPU.putc(y2>>8);
  _serialSMARTGPU.putc(y2);  
  _serialSMARTGPU.putc(x3>>8); 
  _serialSMARTGPU.putc(x3);
  _serialSMARTGPU.putc(y3>>8);
  _serialSMARTGPU.putc(y3);    
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);
  _serialSMARTGPU.putc(fill);   
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::drawCircle(int x, int y, int radius, int colour, unsigned char fill){       //Draw a circle on the screen
  _serialSMARTGPU.putc('C'); 
  _serialSMARTGPU.putc(x>>8); 
  _serialSMARTGPU.putc(x);
  _serialSMARTGPU.putc(y>>8);
  _serialSMARTGPU.putc(y);
  _serialSMARTGPU.putc(radius>>8);
  _serialSMARTGPU.putc(radius);
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);
  _serialSMARTGPU.putc(fill);   
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::putLetter(int x, int y, int colour, unsigned char font, unsigned char fill, unsigned char letter){       //Draw a letter on the screen
  
  _serialSMARTGPU.putc('W'); 
  _serialSMARTGPU.putc(x>>8); 
  _serialSMARTGPU.putc(x);
  _serialSMARTGPU.putc(y>>8);
  _serialSMARTGPU.putc(y);
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);
  _serialSMARTGPU.putc(font); 
  _serialSMARTGPU.putc(fill); 
  _serialSMARTGPU.putc(letter);  
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::string(int x1, int y1, int x2, int y2, int colour, unsigned char font, unsigned char fill, char text[]){       //Draw a string on the screen
  int counter=0;
  
  _serialSMARTGPU.putc('S'); 
  _serialSMARTGPU.putc('N'); //not SD
  _serialSMARTGPU.putc(x1>>8); 
  _serialSMARTGPU.putc(x1);
  _serialSMARTGPU.putc(y1>>8);
  _serialSMARTGPU.putc(y1);
  _serialSMARTGPU.putc(x2>>8); 
  _serialSMARTGPU.putc(x2);
  _serialSMARTGPU.putc(y2>>8);
  _serialSMARTGPU.putc(y2);  
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);
  _serialSMARTGPU.putc(font); 
  _serialSMARTGPU.putc(fill); 
  while(1){
    _serialSMARTGPU.putc(text[counter]);
    if(text[counter]==0x00){
      break;
    }    
    counter++;
  } 
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::stringSD(int x1, int y1, int x2, int y2, int colour, unsigned char font, unsigned char fill, int BS, int BR, char name[]){       //Draw a String from a text file contained on the micro SD card on the screen
  unsigned char counter=0;
  
  _serialSMARTGPU.putc('S'); 
  _serialSMARTGPU.putc('S'); //from SD
  _serialSMARTGPU.putc(x1>>8); 
  _serialSMARTGPU.putc(x1);
  _serialSMARTGPU.putc(y1>>8);
  _serialSMARTGPU.putc(y1);
  _serialSMARTGPU.putc(x2>>8); 
  _serialSMARTGPU.putc(x2);
  _serialSMARTGPU.putc(y2>>8);
  _serialSMARTGPU.putc(y2);  
  _serialSMARTGPU.putc(colour>>8);
  _serialSMARTGPU.putc(colour);
  _serialSMARTGPU.putc(font); 
  _serialSMARTGPU.putc(fill); 
  _serialSMARTGPU.putc(BS>>8);
  _serialSMARTGPU.putc(BS);  
  _serialSMARTGPU.putc(BR>>8);
  _serialSMARTGPU.putc(BR);  
  while(1){
    _serialSMARTGPU.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::icon(int x1, int y1, int x2, int y2, char icon[]){            //Send and image or icon pixel by pixel to SMARTGPU, 16bit(2 bytes) each pixel RGB565
  unsigned int i,j,k=0; 
  
  _serialSMARTGPU.putc('I'); 
  _serialSMARTGPU.putc('N'); //not SD
  _serialSMARTGPU.putc(x1>>8); 
  _serialSMARTGPU.putc(x1);
  _serialSMARTGPU.putc(y1>>8);
  _serialSMARTGPU.putc(y1);
  _serialSMARTGPU.putc(x2>>8); 
  _serialSMARTGPU.putc(x2);
  _serialSMARTGPU.putc(y2>>8);
  _serialSMARTGPU.putc(y2);
  
  //Send icon buffer pixel by pixel
  for(j=0;j<=(y2-y1);j++){
    for(i=0;i<=(x2-x1);i++){
        _serialSMARTGPU.putc(icon[k]);
        k++;
    }
  } 
  return _serialSMARTGPU.getc();  
}

unsigned char SMARTGPU::imageSD(int x, int y, char name[]){        //Draw an Image contained on the micro SD card on the screen, top left corner coordinates
  unsigned char counter=0;
  
  _serialSMARTGPU.putc('I'); 
  _serialSMARTGPU.putc('S'); //from SD
  _serialSMARTGPU.putc(x>>8); 
  _serialSMARTGPU.putc(x);
  _serialSMARTGPU.putc(y>>8);
  _serialSMARTGPU.putc(y);
  while(1){
    _serialSMARTGPU.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  return _serialSMARTGPU.getc();
}

unsigned char SMARTGPU::touchScreen(int buffer[]){          //Ask for a touch on the screen, if return=1, touch coordinates are stored on the buffer[]
  
  _serialSMARTGPU.putc('G');
  buffer[0]=_serialSMARTGPU.getc();
  buffer[0]=buffer[0]<<8;
  buffer[0]|=_serialSMARTGPU.getc();
  buffer[1]=_serialSMARTGPU.getc();
  buffer[1]=buffer[1]<<8;
  buffer[1]|=_serialSMARTGPU.getc();
  _serialSMARTGPU.getc();  
  if(buffer[0]<0x0200){
    return 1;
  }else{
    return 0;
  }
}

unsigned char SMARTGPU::touchIcon(char buffer[]){          //Ask for a touch on the icons of the screen, if return=1, icon name is stored on the buffer[]
  
  _serialSMARTGPU.putc('G');
  buffer[0]=_serialSMARTGPU.getc();
  buffer[1]=_serialSMARTGPU.getc();
  buffer[2]=_serialSMARTGPU.getc();
  buffer[3]=_serialSMARTGPU.getc();
  _serialSMARTGPU.getc();  
  if(!(buffer[0]<0x02) & (buffer[0]!=0x4E)){
    return 1;
  }else{
    return 0;
  }
}
