/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

char imagesOnSDCard[8][30]={"Penguins","Koala","Hydrangeas","Light House","Jellyfish","Tulips","Desert","Flower"}; //array containing the names of the different called images

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  POINT point;
  int pic=0;
    
  initializeSmartGPU2();                     //Init communication with SmartGPU2 board
  
  lcd.SDFopenDir("BMP Images");              //Open the BMP Images that contains the images
  
  while(1){   //Loop forever in the slide show!
    lcd.imageBMPSD(0,0,imagesOnSDCard[pic]); //Load image from SD card, all images are full screen so we load them from top left corner X:0,Y:0
    lcd.imageBMPSD(3,LCD_HEIGHT-20,"previous");        //Load the previous icon          
    lcd.imageBMPSD(LCD_WIDTH-20,LCD_HEIGHT-20,"next"); //Load the next icon
       
    wait_ms(100);                            //A little delay to avoid fast image changing
    while(lcd.touchScreen(&point)==INVALID); //Wait for a touch on the screen to show next or previous picture
    
    //check if we go to the next image, or to the previous one
    if(point.x>(LCD_WIDTH/2)){               //if the received touch was on the right middle of the screen we advance the image, else we decrease and go to previous image
      pic++;                                 //decrease image selector
      if(pic>7){                             //if we reach the position of the last image, we restart to image 0
        pic=0;                 
      }        
    }else{    
      pic--;    
      if(pic<0){                          //if we reach the position of the first image, we move to image 7
        pic=7;  
      }    
    }   
  }
}