/*********************************************************
VIZIC TECHNOLOGIES. COPYRIGHT 2012.
THE DATASHEETS, SOFTWARE AND LIBRARIES ARE PROVIDED "AS IS." 
VIZIC EXPRESSLY DISCLAIM ANY WARRANTY OF ANY KIND, WHETHER 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
OR NONINFRINGEMENT. IN NO EVENT SHALL VIZIC BE LIABLE FOR 
ANY INCIDENTAL, SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, 
LOST PROFITS OR LOST DATA, HARM TO YOUR EQUIPMENT, COST OF 
PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, 
ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO 
ANY DEFENCE THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION,
OR OTHER SIMILAR COSTS.
*********************************************************/
/**************************************************************************************/
/*MINI SMARTGPU intelligent embedded graphics processor unit
 those examples are for use the MINI SMARTGPU with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://vizictechnologies.com/#/mini-smart-gpu/4566376187
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2012*/
/**************************************************************************************/
/**************************************************************************************/
 
#include "mbed.h"
#include "MINISMARTGPU.h"

MINISMARTGPU lcd(p13,p14,p15);        //(TX,RX,Reset); Create Object "lcd"

char imagesOnSDCard[11][9]={"tulips","penguins","abstract","nature","cube","sunset","drop","fractal","jelly","koala","flower"}; //array containing the names of the different called images

/**********************************************************************************/
/**********************************************************************************/
/**********************************************************************************/
int main() { 
  char pic=0;

  lcd.reset();                    //physically reset MINISMARTGPU
  lcd.start();                    //initialize the MINISMARTGPU processor
  wait_ms(200);
    
  while(1){   //Loop forever in the slide show!
    lcd.imageSD(0,0,imagesOnSDCard[pic]); //Load image from SD card, all images are 160x128(full screen) so we load them from top left corner X:0,Y:0
       
    //Wait some seconds to change slide
    wait_ms(2000);
    
    pic++;                               //increase image selector
    if(pic>10){                          //if we reach the position of the last image, we restart to image 0
      pic=0;                 
    }        
  }
}
