/**************************************************************************************/
/*SMARTGPU intelligent embedded graphics processor unit
 those examples are for use the SMARTGPU with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/#/desarrollo/4554296549
 
 This example requires pre-loaded content to the micro SD card, images and text files!
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2011 */
/**************************************************************************************/
/**************************************************************************************/
 
#include "mbed.h"
#include "SMARTGPU.h"

SMARTGPU lcd(p13,p14,p15);        //(TX,RX,Reset);

//Each time we use the touchscreen we must define a int array that stores the X and Y readed or touched coordinates.
int touch[2];
//Each time we use the touchicon we must define a char array that stores the name of the touched icon.
char icon[3];

char imagesOnSDCard[8][9]={"Peng320","Koala320","Hydra320","Lig320","Sea320","Tul320","Des320","Flow320"}; //array containing the names of the different called images

int main() { 
  lcd.reset();                    //physically reset SMARTGPU
  lcd.start();                    //initialize the SMARTGPU processor
  
  int pic=0;
  
  lcd.baudChange(500000);                 // Set a fast baud!, always that we use touch functions is recommended to use fast baud rates

  while(1){   //Loop forever in the slide show!
    lcd.imageSD(0,0,imagesOnSDCard[pic]); //Load image from SD card, all images are 320x240(full screen) so we load them from top left corner X:0,Y:0
    lcd.imageSD(3,219,"prev");            //Load the prev icon        
    lcd.imageSD(300,219,"next");          //Load the next icon
       
    while(!lcd.touchScreen(touch));       //Wait for a touch on the screen to show next or previous picture
    
    //check if we go to the next image, or to the previous one
    if(touch[XCOORD]>160){                //if the received touch was on the right middle of the screen we advance the image, else we decrease and go to previous image
      pic++;                              //decrease image selector
      if(pic>7){                          //if we reach the position of the last image, we restart to image 0
        pic=0;                 
      }        
    }else{
      pic--;    
      if(pic<0){                          //if we reach the position of the first image, we move to image 7
        pic=7;  
      }    
    }   
  }
}

