/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

char pixelArray[3];                     //Array to store the RGB888 pixel obtained with memoryRead()

/**************************************************/
//Funcion to convert a 3 byte array to an int RGB565
int RGB888ToRGB565(char pixBuffer[]){   //get an array of 3 bytes( red, green, blue), and convert them to RGB565 returned in an int
  unsigned char R,G,B;
  unsigned int col;
  unsigned long colour;
  
  R=pixBuffer[0];
  G=pixBuffer[1];
  B=pixBuffer[2]; 
  ((unsigned char *) &colour)[1]=(R & 0xF8);
  R=G;
  G=G>>5;
  ((unsigned char *) &colour)[1]|=G;
  G=(R<<3)& 0xE0;
  ((unsigned char *) &colour)[0]=B;
  ((unsigned char *) &colour)[0]=((unsigned char *) &colour)[0]>>3;  
  ((unsigned char *) &colour)[0]|=G;
  col=colour;
  return col;
}

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  POINT point;
  unsigned char penSize=1;
  COLOUR colour = BLACK;
  char pen[4]={'x','0','1',0x00};    //Array that show the current penSize  
  NUMBEROFBYTES charsPrinted;
  
  initializeSmartGPU2();             //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD7);             //set a fast baud! for fast drawing

  //Load paint design
  lcd.imageBMPSD(0,0,"paint");    
  //strings config
  lcd.setTextColour(GREEN);
  lcd.setTextSize(FONT0);
  lcd.setTextBackFill(FILLED);     
  lcd.string(7,54,48,65,"Erase",&charsPrinted);       //draw Erase word
  lcd.string(77,54,110,65,pen,&charsPrinted);         //draw penSize 
  
  while(1){   //Start the Paint application    
    while(!lcd.touchScreen(&point));                  //Wait for a touch on the screen to do something      
    //Once we get a touch somewhere on the screen:
    if((point.y-penSize)<67){                         //the touch was on the menu
      if(point.x<45){                                 //touch on erase circle
        lcd.drawRectangle(0,67,319,239,WHITE,FILL);   //Draw a white rectangle on drawing area
      }else if(point.x<75){                           //touch to select the eraser
        colour=WHITE;
        lcd.drawCircle(25,34,14,colour,FILL);         //draw WHITE colour circle on top left corner           
      }else if(point.x<108){                          //touch to change pen Size 
        penSize=penSize*2;                            //double the penSize
        if(penSize==16){                              //maximum pen size = 8, if we reach 16 we set to 1.
          penSize=1;
        }          
        pen[1]=(penSize/10)+0x30;                     //get the tens of penSize and convert them to ascii
        pen[2]=(penSize%10)+0x30;                     //get the ones of penSize and convert them to ascii
        lcd.string(77,54,110,65,pen,&charsPrinted);   //draw penSize 
        wait_ms(500);                                 //delay to avoid fast penSize changing            
      }else if(point.x<312 & point.y>20 & point.y<59){//touch on the colours bar                  
        lcd.getImageFromMemory(point.x,point.y,point.x,point.y,pixelArray);  //assign new colour based on touch coordinates and memory read, this function return a 24 bit pixel array, 
        colour=RGB888ToRGB565(pixelArray);
        lcd.drawCircle(25,34,14,colour,FILL);         //draw new selected colour on top left corner           
      }                
    }else{                                            //Touch on drawing area
      lcd.drawCircle(point.x,point.y,penSize,colour,FILL);                    //Draw
    }
  }
}