/**************************************************************************************/
/*SMARTGPU intelligent embedded graphics processor unit
 those examples are for use the SMARTGPU with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/#/desarrollo/4554296549
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2011 */
/**************************************************************************************/
/**************************************************************************************/
 
#include "mbed.h"
#include "SMARTGPU.h"

#define PENSIZE 5         //size of the drawing pen 

SMARTGPU lcd(p13,p14,p15);     //(TX,RX,Reset);

//Each time we use the touchscreen we must define a int array that stores the X and Y readed or touched coordinates.
int touch[2];
//Each time we use the touchicon we must define a char array that stores the name of the touched icon.
char icon[3];

int main() { 
  lcd.reset();                    //physically reset SMARTGPU
  lcd.start();                    //initialize the SMARTGPU processor

  lcd.baudChange(2000000);                                      // Set a fast baud!, always that we use touch functions is recommended to use fast baud rates
  
  //front cover
  lcd.string(85,50,290,220,YELLOW,FONT7,TRANS,"Mini Paint");        
  lcd.string(45,95,290,220,BLUE,FONT5,TRANS,"Touch any icon to erase screen");
  lcd.string(30,160,310,220,MAGENTA,FONT4,TRANS,"Touch screen to begin");
  
  while(!lcd.touchScreen(touch));                                     // Wait for a touch on the screen to start
  lcd.erase();
  wait_ms(500);
  
  while(1){                                                           // Loop forever
    if(lcd.touchScreen(touch)){                                       // If we receive a touch on the screen
      lcd.drawCircle(touch[XCOORD],touch[YCOORD],PENSIZE,GREEN,FILL); // Draw circle on touched coordinates
    }
    if(lcd.touchIcon(icon)){                                          // If we receive a touch on any icon
      lcd.erase();                                                    // Erase screen         
    }
  }
}