/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"


/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  POINT point;
  unsigned char progress=0;
  char sliderPosition=49, scrollPosition=4;
      
  initializeSmartGPU2();             //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD6);             //set a fast baud! for fast drawing
  
//DRAW INITIAL STATE/VALUES OBJECTS
  //draw the object window
  lcd.objWindow(0,0,MAX_X_LANDSCAPE,MAX_Y_LANDSCAPE, FONT1, SELECTEDGRAY, "objects window");
  //draw the object slider
  lcd.objSlider(10, 80, 309, 115, sliderPosition, 100, HORIZONTAL); //draw the slider  with 100 divisions and 49 as current position
  //draw the object scroll bar
  lcd.objScrollBar(10, 125, 309, 160, scrollPosition, 10, HORIZONTAL, DESELECTED); //draw the scroll bar with 10 divisions and 4 as current position
  //draw the object button1 and button2
  lcd.objButton(10, 170, 150, 220, DESELECTED, "button 1");
  lcd.objButton(170, 170, 309, 220, DESELECTED, "button 2");     
     
//LOOP FOREVER AND DRAW ONLY IF TOUCH ON OBJECT     
  while(1){
    //draw the object progress bar - this is the only object that doesn't wait for a touch, it just updates automatically each delay cycle
    lcd.objProgressBar(10, 40, 309, 70, progress++); //draw the progress bar with the "progress" variable value
    if(progress>100) progress = 0;   
 
    //ask for a touch
    if(lcd.touchScreen(&point)==VALID){ //if a touch on screen is valid
      //IF SLIDER
      if(point.y>80 && point.y<115){ //if the touch on the slider
        sliderPosition = ((point.x*100)/(309-10)); //scale the value and set it to sliderPosition
        //draw the object slider with currently obtained scaled touch value
        lcd.objSlider(10, 80, 309, 115, sliderPosition, 100, HORIZONTAL); //draw the slider  with 100 divisions and "sliderPosition" variable value                  
      }
      //IF SCROLLBAR        
      if(point.y>125 && point.y<160){ //if the touch on the scroll bar
        if(point.x>(MAX_X_LANDSCAPE-SCROLLBUTTONSIZE)){ //if touch is on the right > button
          scrollPosition++;          
          if(scrollPosition>9) scrollPosition=9;              
          //draw the object scroll bar as SELECTED
          lcd.objScrollBar(10, 125, 309, 160, scrollPosition, 10, HORIZONTAL, SELECTED); //draw the scroll bar with 10 divisions and "scrollPosition" variable value                      
        }else if(point.x<SCROLLBUTTONSIZE){             //if touch is on the left < button
          scrollPosition--;  
          if(scrollPosition<0) scrollPosition=0;
          //draw the object scroll bar as SELECTED
          lcd.objScrollBar(10, 125, 309, 160, scrollPosition, 10, HORIZONTAL, SELECTED); //draw the scroll bar with 10 divisions and "scrollPosition" variable value    
        }
        wait_ms(50);
        lcd.objScrollBar(10, 125, 309, 160, scrollPosition, 10, HORIZONTAL, DESELECTED); //draw the scroll bar with 10 divisions and "scrollPosition" variable value        
      }
      //IF BUTTON1        
      if(point.y>170 && point.y<220 && point.x<160){ //if the touch on button1
        //draw the object button1 as SELECTED
        lcd.objButton(10, 170, 150, 220, SELECTED, "button 1");
        wait_ms(50);
        lcd.objButton(10, 170, 150, 220, DESELECTED, "button 1");
      }
      //IF BUTTON2        
      if(point.y>170 && point.y<220 && point.x>160){ //if the touch on button2
        //draw the object button2 as SELECTED
        lcd.objButton(170, 170, 309, 220, SELECTED, "button 2");
        wait_ms(50);
        lcd.objButton(170, 170, 309, 220, DESELECTED, "button 2");
      }
    }
    //update objects each 100 milliseconds
    wait_ms(100);      
  }
}