/**************************************************************************************/
/*SMARTGPU intelligent embedded graphics processor unit
 those examples are for use the SMARTGPU with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/#/desarrollo/4554296549
 
 This example requires pre-loaded content, an image to the micro SD card!
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2011 */
/**************************************************************************************/
/**************************************************************************************/
 

#include "mbed.h"
#include "SMARTGPU.h"

//Clock definitions
#define secCol        RED      //seconds hand colour
#define minCol        BLACK    //minutes hand colour
#define hourCol       BLACK    //hours hand colour
#define halfx         160      //this point represent the x center of the clock where math is done
#define halfy         129      //this point represent the y center of the clock where math is done

SMARTGPU lcd(p13,p14,p15);     //(TX,RX,Reset);


int main() { 
  lcd.reset();                    //physically reset SMARTGPU
  lcd.start();                    //initialize the SMARTGPU processor
  
  int secs=3;
  int mins=48;
  int hours=4;
  int xs,ys,xm,ym,xh,yh;
  int angleH,angleM,angleS;
  int handHour=50;//hand size
  int handMin=57;//hand size
  int handSec=62;//hand size  
  
  lcd.baudChange(1000000);                          //set high baud for fast drawing
  lcd.imageSD(0,0,"oldClk");                        //draw the clock body
  
 while(1){
  //Do some Math to get the second point of the clock hands. (first point is always the center of the clock)
  angleS=secs*6;                           //get the current seconds in angle form, a circle have 360 degrees divided by 60 seconds = 6, then we multiply the 6 by the current seconds to get current angle
  xs=(sin((angleS*3.14)/180)) * handSec;   //get X component of the second's hand
  ys=(cos((angleS*3.14)/180)) * handSec;   //get Y component of the second's hand
  angleM=mins*6;                           //get the current minutes in angle form, a circle have 360 degrees divided by 60 minutes = 6, then we multiply the 6 by the current minutes to get current angle
  xm=(sin((angleM*3.14)/180)) * handMin;   //get X component of the minutes's hand
  ym=(cos((angleM*3.14)/180)) * handMin;   //get Y component of the minutes's hand 
  angleH=hours*30;                         //get the current hours in angle form, a circle have 360 degrees divided by 12 hours = 30, then we multiply the 30 by the current hours to get current angle
  xh=(sin((angleH*3.14)/180)) * handHour;  //get X component of the hours's hand
  yh=(cos((angleH*3.14)/180)) * handHour;  //get Y component of the hours's hand
    
  //Draw current time hands  
  lcd.drawLine(halfx,halfy,halfx+xm,halfy-ym,minCol);  // Draw the minutes hand, first point is the center of the clock, and the second is the point obtained by doing math
  lcd.drawLine(halfx,halfy,halfx+xh,halfy-yh,hourCol); // Draw the hours hand, first point is the center of the clock, and the second is the point obtained by doing math
  lcd.drawLine(halfx,halfy,halfx+xs,halfy-ys,secCol);  // Draw the seconds hand, first point is the center of the clock, and the second is the point obtained by doing math
  lcd.drawCircle(halfx,halfy,3,secCol,FILL);           // Draw the center of the second's hand
  
  wait_ms(1000);                                  // wait for one second delay (we dont need to explain why we're waiting one second, right?)

  secs++;                                         // increase seconds
  if(secs==60){                                   // if we reach 60 seconds
    mins++;                                       // increase the minutes
    if(mins==60){                                 // if we reach 60 minutes
      hours++;                                    // increase the minutes
      if(hours==12){                              // if we reach 12 hours
        hours=0;                                  // clear hours
      } 
      mins=0;                                     // clear minutes
    }            
    secs=0;                                       // clear seconds
  }                      
 
  //Erase all hands         
  lcd.drawLine(halfx,halfy,halfx+xs,halfy-ys,WHITE); // Erase Second's hand
  lcd.drawLine(halfx,halfy,halfx+xm,halfy-ym,WHITE); // Erase Minute's hand
  lcd.drawLine(halfx,halfy,halfx+xh,halfy-yh,WHITE); // Erase Hour's hand            
 }
}