 /*********************************************************
VIZIC TECHNOLOGIES. COPYRIGHT 2012.
THE DATASHEETS, SOFTWARE AND LIBRARIES ARE PROVIDED "AS IS." 
VIZIC EXPRESSLY DISCLAIM ANY WARRANTY OF ANY KIND, WHETHER 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
OR NONINFRINGEMENT. IN NO EVENT SHALL VIZIC BE LIABLE FOR 
ANY INCIDENTAL, SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, 
LOST PROFITS OR LOST DATA, HARM TO YOUR EQUIPMENT, COST OF 
PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, 
ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO 
ANY DEFENCE THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION,
OR OTHER SIMILAR COSTS.
*********************************************************/

#include "mbed.h"
#include "MINISMARTGPU.h"
        
// MINI SMART GPU DEFAULT BAUD RATE: 9600bps
//It shoud be used like this : MINISMARTGPU lcd(p13,p14,p15); for serial communication with MINISMARTGPU
MINISMARTGPU::MINISMARTGPU(PinName TXPin, PinName RXPin, PinName resetPin): _serialMINISMARTGPU(TXPin,RXPin), _resetPin(resetPin){    
    init();
}

/********** high level commands, for the user! */
void MINISMARTGPU::init(){         //configure the mbed for MINISMARTGPU board    
    _serialMINISMARTGPU.baud(9600);
    _resetPin=1;               //set the pin to 3.3v to avoid reset 
}
 
void MINISMARTGPU::reset(){        //Reset the MINISMARTGPU board
    _resetPin=0;               //set the pin to GND to reset 
    wait_ms(500);
    _resetPin=1;               //set the pin to 3.3v to end reset
    wait_ms(500);    

}

unsigned char MINISMARTGPU::start(){           //Init the MINISMARTGPU
  wait_ms(500); 
  _serialMINISMARTGPU.putc('U');  
  wait_ms(1500);
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::erase(){          //Erase the MINISMARTGPU screen
  _serialMINISMARTGPU.putc('E');  
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::sleep(unsigned char mode){       //Send MINISMARTGPU to sleep mode
  _serialMINISMARTGPU.putc('Z'); 
  _serialMINISMARTGPU.putc(mode);
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::orientation(unsigned char side){       //Change display orientation
  _serialMINISMARTGPU.putc('O'); 
  _serialMINISMARTGPU.putc(side);
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::bright(unsigned char val){       //Change display brightness
  _serialMINISMARTGPU.putc('V'); 
  _serialMINISMARTGPU.putc(val); 
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::baudChange(unsigned long val){       //Change baud rate of mbed and SMARTGPU board
  unsigned char aux;

  switch(val){
    case 9600:
      aux=0;
    break;
    case 19200:
      aux=1;
    break;
    case 57600:
      aux=2;
    break;
    case 115200:
      aux=3;
    break;
    case 256000:
      aux=4;
    break;    
    case 500000:
      aux=5;
    break;
    case 1000000:
      aux=6;
    break;
    case 2000000:
      aux=7;
    break;
    default:
      return 'F';

  } 
  _serialMINISMARTGPU.putc('X');
  _serialMINISMARTGPU.putc(aux);  
  aux=_serialMINISMARTGPU.getc();

  if(aux=='O'){
    wait_ms(150);
    _serialMINISMARTGPU.baud(val);
    wait_ms(200);
    return _serialMINISMARTGPU.getc();
  }else{
    return aux;
  }
}

unsigned char MINISMARTGPU::setScreenBackground(int colour){       //Change the default screen background colour for erase function
  _serialMINISMARTGPU.putc('B'); 
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);  
  return _serialMINISMARTGPU.getc();
  
}

unsigned char MINISMARTGPU::setTextBackground(int colour){       //Set the default text background colour for letters and strings
  _serialMINISMARTGPU.putc('A'); 
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);  
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::memoryRead(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, char buffer[]){ //Read the internal memory of the MINISMARTGPU, This command returns 24bit pixels (3 bytes)
  unsigned int i,j,k=0;
  
  _serialMINISMARTGPU.putc('M'); 
  _serialMINISMARTGPU.putc(x1);
  _serialMINISMARTGPU.putc(y1);
  _serialMINISMARTGPU.putc(x2);
  _serialMINISMARTGPU.putc(y2); 

  //receive all the pixels
  for(j=0;j<=(y2-y1);j++){
    for(i=0;i<=(x2-x1);i++){
        buffer[k]=_serialMINISMARTGPU.getc(); //Red
        k++;
        buffer[k]=_serialMINISMARTGPU.getc(); //Green
        k++;
        buffer[k]=_serialMINISMARTGPU.getc(); //Blue
        k++;
    }    
  } 
  return _serialMINISMARTGPU.getc();  

}

unsigned char MINISMARTGPU::putPixel(unsigned char x, unsigned char y, int colour){       //Draw a pixel on the screen
  _serialMINISMARTGPU.putc('P'); 
  _serialMINISMARTGPU.putc(x);
  _serialMINISMARTGPU.putc(y);
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::drawLine(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, int colour){       //Draw a line on the screen
  _serialMINISMARTGPU.putc('L'); 
  _serialMINISMARTGPU.putc(x1);
  _serialMINISMARTGPU.putc(y1);
  _serialMINISMARTGPU.putc(x2);
  _serialMINISMARTGPU.putc(y2);  
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::drawRectangle(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, int colour, unsigned char fill){       //Draw a rectangle on the screen
  _serialMINISMARTGPU.putc('R');  
  _serialMINISMARTGPU.putc(x1);
  _serialMINISMARTGPU.putc(y1);
  _serialMINISMARTGPU.putc(x2);
  _serialMINISMARTGPU.putc(y2);  
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);
  _serialMINISMARTGPU.putc(fill);   
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::drawTriangle(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, unsigned char x3, unsigned char y3, int colour, unsigned char fill){       //Draw a triangle on the screen
  _serialMINISMARTGPU.putc('T'); 
  _serialMINISMARTGPU.putc(x1);
  _serialMINISMARTGPU.putc(y1);
  _serialMINISMARTGPU.putc(x2);
  _serialMINISMARTGPU.putc(y2);  
  _serialMINISMARTGPU.putc(x3);
  _serialMINISMARTGPU.putc(y3);    
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);
  _serialMINISMARTGPU.putc(fill);   
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::drawCircle(unsigned char x, unsigned char y, unsigned char radius, int colour, unsigned char fill){       //Draw a circle on the screen
  _serialMINISMARTGPU.putc('C'); 
  _serialMINISMARTGPU.putc(x);
  _serialMINISMARTGPU.putc(y);
  _serialMINISMARTGPU.putc(radius);
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);
  _serialMINISMARTGPU.putc(fill);   
  return _serialMINISMARTGPU.getc();
  
}

unsigned char MINISMARTGPU::putLetter(unsigned char x, unsigned char y, int colour, unsigned char font, unsigned char fill, unsigned char letter){       //Draw a letter on the screen
  _serialMINISMARTGPU.putc('W'); 
  _serialMINISMARTGPU.putc(x);
  _serialMINISMARTGPU.putc(y);
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);
  _serialMINISMARTGPU.putc(font); 
  _serialMINISMARTGPU.putc(fill); 
  _serialMINISMARTGPU.putc(letter);  
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::string(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, int colour, unsigned char font, unsigned char fill, char text[]){       //Draw a string on the screen
  int counter=0;
  
  _serialMINISMARTGPU.putc('S'); 
  _serialMINISMARTGPU.putc('N'); //not SD
  _serialMINISMARTGPU.putc(x1);
  _serialMINISMARTGPU.putc(y1);
  _serialMINISMARTGPU.putc(x2);
  _serialMINISMARTGPU.putc(y2);  
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);
  _serialMINISMARTGPU.putc(font); 
  _serialMINISMARTGPU.putc(fill); 
  while(1){
    _serialMINISMARTGPU.putc(text[counter]);
    if(text[counter]==0x00){
      break;
    }    
    counter++;
  } 
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::stringSD(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, int colour, unsigned char font, unsigned char fill, int BS, int BR, char name[]){       //Draw a String from a text file contained on the micro SD card on the screen
  unsigned char counter=0;
  
  _serialMINISMARTGPU.putc('S'); 
  _serialMINISMARTGPU.putc('S'); //from SD
  _serialMINISMARTGPU.putc(x1);
  _serialMINISMARTGPU.putc(y1);
  _serialMINISMARTGPU.putc(x2);
  _serialMINISMARTGPU.putc(y2);  
  _serialMINISMARTGPU.putc(colour>>8);
  _serialMINISMARTGPU.putc(colour);
  _serialMINISMARTGPU.putc(font); 
  _serialMINISMARTGPU.putc(fill); 
  _serialMINISMARTGPU.putc(BS>>8);
  _serialMINISMARTGPU.putc(BS);  
  _serialMINISMARTGPU.putc(BR>>8);
  _serialMINISMARTGPU.putc(BR);  
  while(1){
    _serialMINISMARTGPU.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  return _serialMINISMARTGPU.getc();

}

unsigned char MINISMARTGPU::icon(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, char icon[]){            //Send and image or icon pixel by pixel to MINISMARTGPU, 16bit(2 bytes) each pixel RGB565
  unsigned int i,j,k=0; 
  
  _serialMINISMARTGPU.putc('I'); 
  _serialMINISMARTGPU.putc('N'); //not SD
  _serialMINISMARTGPU.putc(x1);
  _serialMINISMARTGPU.putc(y1);
  _serialMINISMARTGPU.putc(x2);
  _serialMINISMARTGPU.putc(y2);
  
  //Send icon buffer pixel by pixel
  for(j=0;j<=(y2-y1);j++){
    for(i=0;i<=(x2-x1);i++){
        _serialMINISMARTGPU.putc(icon[k]);
        k++;
    }
  } 
  return _serialMINISMARTGPU.getc();  

}

unsigned char MINISMARTGPU::imageSD(unsigned char x, unsigned char y, char name[]){        //Draw an Image contained on the micro SD card on the screen, top left corner coordinates
  unsigned char counter=0;
  
  _serialMINISMARTGPU.putc('I'); 
  _serialMINISMARTGPU.putc('S'); //from SD
  _serialMINISMARTGPU.putc(x);
  _serialMINISMARTGPU.putc(y);
  
  while(1){
    _serialMINISMARTGPU.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  return _serialMINISMARTGPU.getc();

}

/****************************************************************/
//Those next functions return file execution status instead of ACK 'O' or NAK 'F'
/****************************************************************/

unsigned char MINISMARTGPU::SDfopen(unsigned char mode, char name[]){
  unsigned char counter=0;
  unsigned char aux = 0;
  
  wait_ms(1);
  _serialMINISMARTGPU.putc('F'); //memory card file management
  _serialMINISMARTGPU.putc('O'); //file open
  _serialMINISMARTGPU.putc(mode);
  while(1){
    _serialMINISMARTGPU.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  aux= _serialMINISMARTGPU.getc();   //Get FAT result
  _serialMINISMARTGPU.getc();        //Discard 'O' or 'F'
  return aux;                        //Return FAT result
}

unsigned char MINISMARTGPU::SDfclose(){
  unsigned char aux = 0;

  wait_ms(5);
  _serialMINISMARTGPU.putc('F'); //memory card file management
  _serialMINISMARTGPU.putc('C'); //file close
  
  aux= _serialMINISMARTGPU.getc();   //Get FAT result
  _serialMINISMARTGPU.getc();        //Discard 'O' or 'F'
  return aux;                        //Return FAT result
}

unsigned char MINISMARTGPU::SDfsync(){
  unsigned char aux = 0;
  
  _serialMINISMARTGPU.putc('F'); //memory card file management
  _serialMINISMARTGPU.putc('S'); //file sync

  aux= _serialMINISMARTGPU.getc();   //Get FAT result
  _serialMINISMARTGPU.getc();        //Discard 'O' or 'F'
  return aux;                        //Return FAT result
}

unsigned char MINISMARTGPU::SDfpointer(unsigned long position){
  unsigned char aux = 0;
  
  _serialMINISMARTGPU.putc('F'); //memory card file management
  _serialMINISMARTGPU.putc('P'); //file sync
  _serialMINISMARTGPU.putc(position>>24);
  _serialMINISMARTGPU.putc(position>>16);
  _serialMINISMARTGPU.putc(position>>8);
  _serialMINISMARTGPU.putc(position);
  
  aux= _serialMINISMARTGPU.getc();   //Get FAT result
  _serialMINISMARTGPU.getc();        //Discard 'O' or 'F'
  return aux;                        //Return FAT result 
}    

unsigned char MINISMARTGPU::SDfread(unsigned int BTR, char buffer[], unsigned int *SRB){ //Bytes to Read, Read Buffer, Succesfully Readed Bytes
  unsigned char aux = 0;
  unsigned int x=0, sr=0;

  _serialMINISMARTGPU.putc('F'); //memory card file management
  _serialMINISMARTGPU.putc('R'); //file read
  _serialMINISMARTGPU.putc(BTR>>8);
  _serialMINISMARTGPU.putc(BTR);  
  for(x=0;x<BTR;x++){
    buffer[x]=_serialMINISMARTGPU.getc();
  }
  sr=_serialMINISMARTGPU.getc();
  sr=sr<<8;
  sr|=_serialMINISMARTGPU.getc();
 
  aux= _serialMINISMARTGPU.getc();   //Get FAT result
  _serialMINISMARTGPU.getc();        //Discard 'O' or 'F'
  *SRB = sr;
  return aux;                        //Return FAT result
}    

unsigned char MINISMARTGPU::SDfwrite(unsigned int BTW, char buffer[], unsigned int *SWB){ //Bytes to Write, Write Buffer, Succesfully Written Bytes
  unsigned char aux = 0;
  unsigned int x=0, sw=0;
  
  wait_ms(1);
  if(BTW>512){       //Mini SmartGPU accept to write more than 512 bytes, however this is not recommended, remove this IF for fully write support
    aux = 19;        //Invalid Parameter == 19
  }else{
    _serialMINISMARTGPU.putc('F'); //memory card file management
    _serialMINISMARTGPU.putc('W'); //file write
    _serialMINISMARTGPU.putc(BTW>>8);
    _serialMINISMARTGPU.putc(BTW);    
    for(x=0;x<BTW;x++){
        _serialMINISMARTGPU.putc(buffer[x]);
    }
    sw=_serialMINISMARTGPU.getc();
    sw=sw<<8;
    sw|=_serialMINISMARTGPU.getc();
 
    aux= _serialMINISMARTGPU.getc();   //Get FAT result
    _serialMINISMARTGPU.getc();        //Discard 'O' or 'F'
    *SWB = sw;  
  }
  return aux;           //Return FAT result   
}
