/*********************************************************
VIZIC TECHNOLOGIES. COPYRIGHT 2012.
THE DATASHEETS, SOFTWARE AND LIBRARIES ARE PROVIDED "AS IS." 
VIZIC EXPRESSLY DISCLAIM ANY WARRANTY OF ANY KIND, WHETHER 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
OR NONINFRINGEMENT. IN NO EVENT SHALL VIZIC BE LIABLE FOR 
ANY INCIDENTAL, SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, 
LOST PROFITS OR LOST DATA, HARM TO YOUR EQUIPMENT, COST OF 
PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, 
ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO 
ANY DEFENCE THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION,
OR OTHER SIMILAR COSTS.
*********************************************************/

#ifndef MINISMARTGPU_H
#define MINISMARTGPU_H

#include <mbed.h>

//******************LIBRARY DEFINED PINS (don't modify)*******************//
//General definitions
#define RESET 13
#define TX 1
#define RX 0
#define OFF 0
#define ON 1
#define FULL 127
#define UNFILL 0
#define FILL 1
#define TRANS 0
#define COLOUR 1
#define BEGINNING 0
#define ALLCONTENTS 0
#define LANDSCAPEL  0x00  //left
#define PORTRAITL   0x01  //low
#define LANDSCAPER  0x02  //right
#define PORTRAITT   0x03  //top
#define GND 0
#define VCC 1
#define XCOORD 0
#define YCOORD 1
#define WIDTHLANDSCAPE     160
#define HEIGHTLANDSCAPE    128
#define WIDTHPORTRAIT      128
#define HEIGHTLANDPORTRAIT 160

//basic colours definition
#define BLACK   0x0000
#define WHITE   0xFFFF
#define RED     0xF800
#define GREEN   0x07E0
#define BLUE    0x001F
#define YELLOW  0xFFE0
#define CYAN    0x07FF
#define MAGENTA 0xF81F

//File access definitions
#define READONLY     0x01
#define WRITEONLY    0x02
#define READWRITE    0x03
#define CREATENEW    0x04
#define OPENALWAYS   0x10
#define CREATEALWAYS 0x08
//fonts definition
#define FONT0   0x00
#define FONT1   0x01
#define FONT2   0x02
#define FONT3   0x03
#define FONT4   0x04
#define FONT5   0x05
#define FONT6   0x06
#define FONT7   0x07

//**************************************************************************
// class MINISMARTGPU MINISMARTGPU.h
// This is the main class. It shoud be used like this : SMARTGPU lcd(p13,p14,p15);

class MINISMARTGPU{
    
public:
    
    MINISMARTGPU(PinName TXPin, PinName RXPin, PinName resetPin);
    
    void init();

    void reset();
    
    unsigned char start();  

    unsigned char erase();

    unsigned char sleep(unsigned char);
    
    unsigned char orientation(unsigned char);
    
    unsigned char bright(unsigned char);
    
    unsigned char baudChange(unsigned long val);
    
    unsigned char digitalOut(unsigned char, unsigned char);
    
    unsigned char setScreenBackground(int);
    
    unsigned char setTextBackground(int);
    
    unsigned char memoryRead(unsigned char, unsigned char, unsigned char, unsigned char, char[]);
    
    unsigned char putPixel(unsigned char, unsigned char, int);
    
    unsigned char drawLine(unsigned char, unsigned char, unsigned char, unsigned char, int);
    
    unsigned char drawRectangle(unsigned char, unsigned char, unsigned char, unsigned char, int, unsigned char);
    
    unsigned char drawTriangle(unsigned char, unsigned char, unsigned char, unsigned char, unsigned char, unsigned char, int, unsigned char);
    
    unsigned char drawCircle(unsigned char, unsigned char, unsigned char, int, unsigned char);
    
    unsigned char putLetter(unsigned char, unsigned char, int, unsigned char, unsigned char, unsigned char);
    
    unsigned char string(unsigned char, unsigned char, unsigned char, unsigned char, int, unsigned char, unsigned char, char[]);
    
    unsigned char stringSD(unsigned char, unsigned char, unsigned char, unsigned char, int, unsigned char, unsigned char, int, int, char[]);
    
    unsigned char icon(unsigned char, unsigned char, unsigned char, unsigned char, char[]);
    
    unsigned char imageSD(unsigned char , unsigned char , char[]);

	/****************************************************************/
//Those next functions return file execution status instead of ACK 'O' or NAK 'F'
/****************************************************************/	
	unsigned char SDfopen(unsigned char, char[]);
	
	unsigned char SDfclose();
	
	unsigned char SDfsync();
	
	unsigned char SDfpointer(unsigned long);	

	unsigned char SDfread(unsigned int, char[], unsigned int*);	
	
	unsigned char SDfwrite(unsigned int, char[], unsigned int*);	

    protected :

    Serial     _serialMINISMARTGPU;
    DigitalOut _resetPin;
    
};
typedef unsigned char BYTE;

#endif
