/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

/********************************************************
 This simple sketch does the next:
 1.- list the dirs and files
 2.- print the number of dirs and files
 3.- print the names while they fit
********************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

FILERESULT res;            //create the variable that will store all SMARTGPU2 commands responses

unsigned int row=10;

//function that loops forever on error
void die(unsigned char response){ //if the response is different than OK, print and loop forever
  NUMBEROFBYTES charsPrint;
  if(response!=F_OK){
    lcd.string(10,row,319,239,"Error on microSD... forever loop@",&charsPrint);
    while(1);  
  }
}

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  char buffer[100]={0}; 
  unsigned int dirs=0, files=0, i=0;
  NUMBEROFBYTES charsPrinted;

  initializeSmartGPU2();             //Init communication with SmartGPU2 board

  //strings config
  lcd.setTextColour(GREEN);  
  lcd.setTextSize(FONT1);    
    
  lcd.string(10,row,319,239,"List dirs, files + print names demo!",&charsPrinted); row+=20;
  lcd.setTextSize(FONT0);        
  lcd.string(10,row,319,239,"List Dirs and Files...",&charsPrinted);               row+=15;
  res=lcd.SDFgetList(&dirs,&files);    //obtain dirs and files
  die(res);
  lcd.string(10,row,319,239,"Dirs:",&charsPrinted);
  lcd.printNumber(40,row,dirs); //print the obtained directories
  lcd.string(70,row,319,239,"Files:",&charsPrinted);    
  lcd.printNumber(105,row,files); //print the obtained files    
  row+=15;

  //print dir names
  lcd.string(10,row,319,239,"Dir Names--------------------",&charsPrinted);             row+=12;
  for(i=0;i<dirs;i++){
    res=lcd.SDFgetDirName(i,buffer); //get Dir number i name in buffer
    die(res);
    lcd.string(10,row,319,239,buffer,&charsPrinted); row+=12;      //print the name if fit
  }
  row+=10;
  //print file names
  lcd.string(10,row,319,239,"File Names--------------------",&charsPrinted);             row+=12;
  for(i=0;i<files;i++){
    res=lcd.SDFgetFileName(i,buffer); //get Dir number i name in buffer
    die(res);
    lcd.string(10,row,319,239,buffer,&charsPrinted); row+=12;      //print the name if fit
  }    
  
  while(1); //loop forever    
}