/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/


#include "mbed.h"
#include "SMARTGPU2.h"

#define orange   0xFC0F
#define brown    0xBBCA
#define ligBlue  0x96DD

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  
  initializeSmartGPU2();             //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD7);             //set a fast baud! for fast drawing
  
  //draw a background
  lcd.drawGradientRect(0,0,319,239,BLUE,BLACK,VERTICAL);                                             //draw a gradient rectangle

  //draw the house
  lcd.drawRectangle(78,134,212,217,orange,FILL);                                                     //draw a rectangle
  lcd.drawRectangle(78,134,212,217,BLACK,UNFILL);                                                    //draw a rectangle   
  lcd.drawTriangle(75,133,216,133,146,63,RED,FILL);                                                  //draw a triangle     
  lcd.drawTriangle(75,133,216,133,146,63,BLACK,UNFILL);                                              //draw a triangle     
  lcd.drawRectangle(136,167,170,217,brown,FILL);                                                     //draw a rectangle
  lcd.drawRectangle(136,167,170,217,BLACK,UNFILL);                                                   //draw a rectangle
  lcd.drawCircle(106,160,15,ligBlue,FILL);                                                           //draw a circle
  lcd.drawCircle(106,160,15,BLACK,UNFILL);                                                           //draw a circle    
  lcd.drawEllipse(195,177,10,15,ligBlue,FILL);                                                       //draw an ellipse
  lcd.drawEllipse(195,177,10,15,BLACK,UNFILL);                                                       //draw an ellipse
    
  //draw left tree
  lcd.drawRectangle(25,157,45,218,brown,FILL);                                                       //draw a rectangle
  lcd.drawRectangle(25,157,45,218,BLACK,UNFILL);                                                     //draw a rectangle       
  lcd.drawEllipse(35,120,35,40,GREEN,FILL);                                                          //draw an ellipse
  lcd.drawEllipse(35,120,35,40,BLACK,UNFILL);                                                        //draw an ellipse
  //draw right tree
  lcd.drawRectangle(270,167,283,218,brown,FILL);                                                     //draw a rectangle
  lcd.drawRectangle(270,167,283,218,BLACK,UNFILL);                                                   //draw a rectangle       
  lcd.drawCircle(277,134,35,GREEN,FILL);                                                             //draw a circle
  lcd.drawCircle(277,134,35,BLACK,UNFILL);                                                           //draw a circle  
    
  //draw grass
  lcd.drawLine(5,218,314,218,GREEN);                                                                 //draw a line    
    
  //loop forever
  while(1);
}
