/*********************************************************
VIZIC TECHNOLOGIES. COPYRIGHT 2012.
THE DATASHEETS, SOFTWARE AND LIBRARIES ARE PROVIDED "AS IS." 
VIZIC EXPRESSLY DISCLAIM ANY WARRANTY OF ANY KIND, WHETHER 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
OR NONINFRINGEMENT. IN NO EVENT SHALL VIZIC BE LIABLE FOR 
ANY INCIDENTAL, SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, 
LOST PROFITS OR LOST DATA, HARM TO YOUR EQUIPMENT, COST OF 
PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, 
ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO 
ANY DEFENCE THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION,
OR OTHER SIMILAR COSTS.
*********************************************************/
/**************************************************************************************/
/*MINI SMARTGPU intelligent embedded graphics processor unit
 those examples are for use the MINI SMARTGPU with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://vizictechnologies.com/#/mini-smart-gpu/4566376187
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2012*/
/**************************************************************************************/
/**************************************************************************************/
 
#include "mbed.h"
#include "MINISMARTGPU.h"

//Some colour definitions
#define orange   0xFC0F
#define brown    0xBBCA
#define ligBlue  0x96DD

MINISMARTGPU lcd(p13,p14,p15);        //(TX,RX,Reset); Create Object "lcd"

int main() { 
  lcd.reset();                    //physically reset MINISMARTGPU
  lcd.start();                    //initialize the MINISMARTGPU processor
  wait_ms(200);
  
    //draw the house
    lcd.drawRectangle(38,58,112,126,orange,FILL);                    //draw a rectangle
    lcd.drawRectangle(38,58,112,126,BLACK,UNFILL);
    lcd.drawRectangle(45,75,68,93,ligBlue,FILL);
    lcd.drawRectangle(45,75,68,93,BLACK,UNFILL);
    lcd.drawLine(56,75,56,93,BLACK);
    lcd.drawLine(45,84,68,84,BLACK);    
    lcd.drawCircle(96,83,11,ligBlue,FILL);                           //draw a circle
    lcd.drawCircle(96,83,11,BLACK,UNFILL);    
    lcd.drawRectangle(68,100,89,126,brown,FILL);
    lcd.drawRectangle(68,100,89,126,BLACK,UNFILL);
    lcd.drawTriangle(33,59,76,22,117,59,brown,FILL);                 //draw a triangle         

    //draw trees
    lcd.drawRectangle(11,89,23,126,brown,FILL);
    lcd.drawRectangle(133,89,145,126,brown,FILL);
    lcd.drawCircle(139,75,15,GREEN,FILL);                            //draw a circle
    lcd.drawCircle(17,75,14,GREEN,FILL);                             //draw a circle
    
    //draw grass
    lcd.drawLine(0,127,159,127,GREEN);                               //draw a line    
      
    //loop forever
    while(1);
}