/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"


/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  POINT p1, p2;
  COLOUR firstColour,lastColour;
      
  initializeSmartGPU2();             //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD7);             //set a fast baud! for fast drawing
  
  p1.x= 0;
  p1.y= 0;
  p2.x= MAX_X_LANDSCAPE;
  p2.y= MAX_Y_LANDSCAPE;

  while(1){//forever
    firstColour=(rand()%65536);     //get a random number 0-65535
    lastColour= (rand()%65536);     //get a random number 0-65535
      
    wait_ms(100);                   //a little delay to visualize smooth colours
      
    //draw the gradient rectangle
    if(lcd.drawGradientRect(p1.x,p1.y,p2.x,p2.y,firstColour,lastColour,HORIZONTAL) != 'O'){ //draw a gradient rectangle
      while(1);                    //loop forever if different than 'O'--OK
    }
  }
}