/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/


#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

char imagesOnSDCard[8][30]={"Penguins","Koala","Hydrangeas","Light House","Jellyfish","Tulips","Desert","Flower"}; //array containing the names of the different called images

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  POINT point;
  char pic=0;
  unsigned char i=0;
  NUMBEROFBYTES charsPrinted;
    
  initializeSmartGPU2();             //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD6);             //set a fast baud! for fast drawing
  lcd.SDFopenDir("JPG Images");      // Open the JPG Images that contain the jpg images
  //strings config
  lcd.setTextColour(GREEN);
  lcd.setTextSize(FONT1);  
  
  while(1){   //Loop forever in the slide show!
    for(i=0;i<4;i++){
      lcd.imageJPGSD(i*(LCD_WIDTH/4),(LCD_HEIGHT/8),SCALE1_4,imagesOnSDCard[i]);     //Load image from SD card            
    }
    for(i=0;i<4;i++){
      lcd.imageJPGSD(i*(LCD_WIDTH/4),(LCD_HEIGHT/8)*5,SCALE1_4,imagesOnSDCard[i+4]); //Load image from SD card            
    }

    lcd.string(LCD_WIDTH/5,10,MAX_X_LANDSCAPE,MAX_Y_LANDSCAPE,"Touch image to load!",&charsPrinted);
    while(lcd.touchScreen(&point)==INVALID);  //Wait for a touch on the screen to show next or previous picture    
    lcd.erase();
    
    if(point.y<(LCD_HEIGHT/2)){    //touch on upper part
       lcd.imageJPGSD(0,0,SCALE1_1,imagesOnSDCard[point.x/(LCD_WIDTH/4)]); //Load image from SD card, all images are 320x240(full screen) so we load them from top left corner X:0,Y:0        
    }else{                       //touch on upper part
       lcd.imageJPGSD(0,0,SCALE1_1,imagesOnSDCard[(point.x/(LCD_WIDTH/4))+4]); //Load image from SD card, all images are 320x240(full screen) so we load them from top left corner X:0,Y:0                    
    }

    lcd.string(LCD_WIDTH/5,LCD_HEIGHT-25,MAX_X_LANDSCAPE,MAX_Y_LANDSCAPE,"Touch image to exit!",&charsPrinted); 
    while(lcd.touchScreen(&point)==INVALID);  //Wait for a touch on the screen to show next or previous picture    
    lcd.erase();
  }
}