/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

/********************************************************
 This simple sketch does the next:
 1.- try open the "test file.txt" file in the microSD root path in write only mode 
 2.- if doesn't exist, create the file - if exist overwritte the file
 3.- open again the "test file.txt" file in the microSD root path in write only mode 
 4.- write "Data Written by the SmartDRIVE Processor" to the .txt file
 5.- save contents and close file
 6.- open again the file in read only mode
 7.- read from file to a buffer
 8.- verify data read to be equal to message
 9.- if different erase the created file else keep the file
 10- umount drive
 11.- end
 
- remove microSD card and search for the file on a PC with the written contents
********************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

FILERESULT res;            //create the variable that will store all SMARTGPU2 commands responses

char message[41]="Data Written by the SmartGPU 2 Processor";
unsigned int row=10;

//function that loops forever on error
void die(FILERESULT response){ //if the response is different than OK, print and loop forever
  NUMBEROFBYTES charsPrint;
  if(response!=F_OK){
    lcd.string(10,row,319,239,"Error... forever loop @",&charsPrint);
    while(1);  
  }
}

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  NUMBEROFBYTES charsPrinted;
  char buffer[50]={0};
  unsigned int writtenBytes=0, readbytes=0, i=0;   
  
  initializeSmartGPU2();             //Init communication with SmartGPU2 board

  //strings config
  lcd.setTextColour(GREEN);    
  lcd.string(10,row,319,239,"FAT file open, read, write demo!",&charsPrinted);           row+=15;
  lcd.string(10,row,319,239,"Open File <test file.txt> in WRITE mode...",&charsPrinted); row+=15;
   
  //try to open the file
  res=lcd.SDFopenFile("test file.txt", WRITEONLY, WORKSPACE0);  //Try to open a file called "testFile.txt" in write only mode in the workspace block 0    
  if(res!=F_OK){                       //If the file doesn't Open is because it doesn't exist      
    lcd.string(10,row,319,239,"File doesn't exist, creating file...",&charsPrinted); row+=15;    
    res=lcd.SDFnewFile("test file.txt");  //Try to create the file 
    die(res);                        //If any error loop forever
    res=lcd.SDFopenFile("test file.txt", WRITEONLY, WORKSPACE0);  //Try to open the created file      
    die(res);                        //If any error loop forever
  }
  
  //Up to here the file exist and is open    
  lcd.string(10,row,319,239,"File Successfully Open in WRITE mode...",&charsPrinted); row+=15;    
  lcd.string(10,row,319,239,"Write <Data Written by the SmartGPU 2 Processor>",&charsPrinted); row+=15;    
  res=lcd.SDFwriteFile(message, sizeof(message), &writtenBytes, WORKSPACE0); //write to the open file in WORKSPACE0 size of message in bytes and store the successfully written Bytes on writtenBytes variable
  die(res);                         //If any error loop forever    
  lcd.SDFsaveFile(WORKSPACE0);          //Save changes in the file contained in WORKSPACE0
  lcd.string(10,row,319,239,"Closing File...",&charsPrinted); row+=15;    
  lcd.SDFcloseFile(WORKSPACE0);         //Close the file --------------------
  
  //Now lets verify contents
  //open again the file in read only mode
  lcd.string(10,row,319,239,"Open File <test file.txt> in READ mode...",&charsPrinted); row+=15;    
  res=lcd.SDFopenFile("test file.txt", READONLY, WORKSPACE0);  //Try to open again the file read only mode in the workspace block 0
  die(res);                         //If any error loop forever
  //read the file  
  lcd.string(10,row,319,239,"File Successfully Open in READ mode...",&charsPrinted); row+=15;    
  lcd.string(10,row,319,239,"Read bytes from file to buffer...",&charsPrinted); row+=15;    
  res=lcd.SDFreadFile(buffer, sizeof(message), &readbytes, WORKSPACE0); //read size of message in bytes from the open file in WORKSPACE0 and store the successfully read Bytes on readbytes variable
  die(res);                         //If any error loop forever        
  lcd.string(10,row,319,239,"Closing File...",&charsPrinted); row+=15;        
  lcd.SDFcloseFile(WORKSPACE0);         //Close the file --------------------
  
  //check contents
  lcd.string(10,row,319,239,"Verify/Compare contents...",&charsPrinted); row+=15;            
  for(i=0;i<sizeof(message);i++){      
    if(message[i]!=buffer[i]){ //if contents are different
      lcd.string(10,row,319,239,"Contents differ, erasing the created file...END",&charsPrinted); row+=10;                  
      lcd.SDFeraseDirFile("test file.txt"); //erase the File
      while(1);
    }
  }
  lcd.string(10,row,319,239,"Contents are equal...END",&charsPrinted);
  while(1);
}