/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

/********************************************************
 This simple sketch does the next:
 1.- init/Clear EEPROM buffer with 0xFF - EEPROM buffer size is 2048 (2k)
 2.- write data 10 times to EEPROM buffer "0123456789"
 3.- compare EEPROM buffer contents with EEPROM PAGE0, if equal go to step 7, if not continue to step 4
 4.- erase EEPROM PAGE0
 5.- save current EEPROM buffer contents(100 x "0123456789") to EEPROM PAGE0
 6.- compare again EEPROM buffer contents with EEPROM PAGE0
 7.- show results on display
 8.- end
 
- once executed the above, remove power from SmartGPU and run sketch again, EEPROM contents will remain as they are non-volatile data
********************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

unsigned int row=10;

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  NUMBEROFBYTES charsPrinted;
  char data[]="0123456789";
  unsigned int i=0;        
  unsigned char result=0;

  initializeSmartGPU2();             //Init communication with SmartGPU2 board    
  lcd.baudChange(BAUD6);             //set a fast baud! for fast drawing
    
  //strings config
  lcd.setTextColour(GREEN);  
  lcd.string(10,row,319,239,"EEPROM page open, read, write demo!",&charsPrinted);   row+=30;
  lcd.string(10,row,319,239,"Performing procedure...",&charsPrinted);               row+=30;

  //ONCE WE START USING EEPROM BUFFER WE CAN'T CALL OTHER SMARTGPU FUNCTIONS DIFFERENT THAN EEPROM 'E' FUNCTIONS, AS EEPROM BUFFER WILL BE DISCARDED IF SO
  //init/Clear EEPROM buffer with 0xFF values
  lcd.initClearEEPROMBuff();

  //write data array 10 times to EEPROM buffer
  for(i=0; i < 10; i++){ 
    lcd.writeEEPROMBuff(data, i*10, 10, &charsPrinted);
  }
  
  //verify contents - EEPROM buffer contents vs EEPROM PAGE0
  lcd.compBuffToEEPROMPage(PAGE0, &result);  //compare EEPROM buffer contents with EEPROM PAGE0
  
  if(result == 1){  //if contents are equal - means that data was already written and its equal
      lcd.string(10,row,319,239,"EEPROM PAGE0 Contents were already equal...END",&charsPrinted);
  }else{            //if contents are different - erase PAGE0 and write EEPROM buffer into PAGE0 - This procedure will be executed only the veryfirst time
    //erase EEPROM PAGE0
    lcd.eraseEEPROMPage(PAGE0);
    //save current EEPROM buffer contents(100 x "0123456789") to EEPROM PAGE0
    lcd.saveBuffToEEPROMPage(PAGE0);            
    //verify contents again - EEPROM buffer contents vs EEPROM PAGE0
    lcd.compBuffToEEPROMPage(PAGE0, &result);  //compare EEPROM buffer contents with EEPROM PAGE0          
     if(result == 1){ //if contents are equal
      lcd.string(10,row,319,239,"New EEPROM PAGE0 Contents are equal...END",&charsPrinted);
    }else{           //error
      lcd.string(10,row,319,239,"New EEPROM PAGE0 Contents differ...END",&charsPrinted);
    }        
  }
  
  //loop forever
  while(1);
}