/*********************************************************
VIZIC TECHNOLOGIES. COPYRIGHT 2012.
THE DATASHEETS, SOFTWARE AND LIBRARIES ARE PROVIDED "AS IS." 
VIZIC EXPRESSLY DISCLAIM ANY WARRANTY OF ANY KIND, WHETHER 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
OR NONINFRINGEMENT. IN NO EVENT SHALL VIZIC BE LIABLE FOR 
ANY INCIDENTAL, SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, 
LOST PROFITS OR LOST DATA, HARM TO YOUR EQUIPMENT, COST OF 
PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, 
ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO 
ANY DEFENCE THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION,
OR OTHER SIMILAR COSTS.
*********************************************************/
/**************************************************************************************/
/*MINI SMARTGPU intelligent embedded graphics processor unit
 those examples are for use the MINI SMARTGPU with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://vizictechnologies.com/#/mini-smart-gpu/4566376187
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2012*/
/**************************************************************************************/
/**************************************************************************************/
 
#include "mbed.h"
#include "MINISMARTGPU.h"

MINISMARTGPU lcd(p13,p14,p15);        //(TX,RX,Reset); Create Object "lcd"

// defines for balls
#define radiusBall1 10     //ball1 size
#define colourBall1 GREEN  //ball1 colour
#define radiusBall2 5      //ball2 size
#define colourBall2 YELLOW //ball2 colour
#define radiusBall3 8      //ball3 size
#define colourBall3 RED    //ball3 colour
#define radiusBall4 15     //ball4 size
#define colourBall4 BLUE   //ball4 colour

//variables used by move ball methods
int speedBall1=2; //ball1 moving speed - amount of pixels that ball move each time
int speedBall2=3; //ball2 moving speed - amount of pixels that ball move each time 
int speedBall3=5; //ball3 moving speed - amount of pixels that ball move each time 
int speedBall4=4; //ball4 moving speed - amount of pixels that ball move each time 
int dirx1=1;      //xball1 initial positive direction
int diry1=1;      //yball1 initial positive direction
int xBall1=110;   //x initial position of ball1
int yBall1=80;    //y initial position of ball1
int dirx2=-1;     //xball2 initial negative direction
int diry2=-1;     //yball2 initial negative direction
int xBall2=20;    //x initial position of ball2
int yBall2=70;    //y initial position of ball2
int dirx3=-1;     //xball3 initial negative direction
int diry3=1;      //yball3 initial negative direction
int xBall3=60;    //x initial position of ball3
int yBall3=15;    //y initial position of ball3
int dirx4=1;      //xball4 initial negative direction
int diry4=-1;     //yball4 initial negative direction
int xBall4=130;   //x initial position of ball4
int yBall4=80;    //y initial position of ball4

/***************************************************/
//Function that updates the current position of the ball1
void moveBall1(){
   lcd.drawCircle(xBall1,yBall1,radiusBall1,BLACK,UNFILL);       // Erase previous ball position
   xBall1+=(dirx1*speedBall1);                                   // Calculate new x coordinate for ball1 
   yBall1+=(diry1*speedBall1);                                   // Calculate new y coordinate for ball1  
   lcd.drawCircle(xBall1,yBall1,radiusBall1,colourBall1,UNFILL); // Draw new ball position
   if((xBall1+speedBall1+radiusBall1)>158 | (xBall1-speedBall1-radiusBall1)<=1){           // if ball reaches the left or right corner, we invert moving direction 
    dirx1= dirx1*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall1+speedBall1+radiusBall1)>126 | (yBall1-speedBall1-radiusBall1)<=1){           // if ball reaches the top or bottom corner, we invert moving direction 
    diry1= diry1*(-1);                                         // Invert the moving direction by multiplying by -1
   }                       
}

/***************************************************/
//Function that updates the current position of the ball2
void moveBall2(){                    
   lcd.drawCircle(xBall2,yBall2,radiusBall2,BLACK,FILL);       // Erase previous ball position
   xBall2+=(dirx2*speedBall2);                                 // Calculate new x coordinate for ball2
   yBall2+=(diry2*speedBall2);                                 // Calculate new y coordinate for ball2  
   lcd.drawCircle(xBall2,yBall2,radiusBall2,colourBall2,FILL); // Draw new ball position
   if((xBall2+speedBall2+radiusBall2)>158 | (xBall2-speedBall2-radiusBall2)<=1){  // if ball reaches the left or right corner, we invert moving direction
    dirx2= dirx2*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall2+speedBall2+radiusBall2)>126 | (yBall2-speedBall2-radiusBall2)<=1){  // if ball reaches the top or bottom corner, we invert moving direction 
     diry2= diry2*(-1);                                        // Invert the moving direction by multiplying by -1
   }                        
}

/***************************************************/
//Function that updates the current position of the ball3
void moveBall3(){                    
   lcd.drawCircle(xBall3,yBall3,radiusBall3,BLACK,FILL);       // Erase previous ball position
   xBall3+=(dirx3*speedBall3);                                 // Calculate new x coordinate for ball3
   yBall3+=(diry3*speedBall3);                                 // Calculate new y coordinate for ball3  
   lcd.drawCircle(xBall3,yBall3,radiusBall3,colourBall3,FILL); // Draw new ball position
   if((xBall3+speedBall3+radiusBall3)>158 | (xBall3-speedBall3-radiusBall3)<=1){  // if ball reaches the left or right corner, we invert moving direction
    dirx3= dirx3*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall3+speedBall3+radiusBall3)>126 | (yBall3-speedBall3-radiusBall3)<=1){  // if ball reaches the top or bottom corner, we invert moving direction 
     diry3= diry3*(-1);                                        // Invert the moving direction by multiplying by -1
   }                        
}

/***************************************************/
//Function that updates the current position of the ball4
void moveBall4(){
   lcd.drawCircle(xBall4,yBall4,radiusBall4,BLACK,UNFILL);       // Erase previous ball position
   xBall4+=(dirx4*speedBall4);                                   // Calculate new x coordinate for ball4 
   yBall4+=(diry4*speedBall4);                                   // Calculate new y coordinate for ball4  
   lcd.drawCircle(xBall4,yBall4,radiusBall4,colourBall4,UNFILL); // Draw new ball position
   if((xBall4+speedBall4+radiusBall4)>158 | (xBall4-speedBall4-radiusBall4)<=1){           // if ball reaches the left or right corner, we invert moving direction 
    dirx4= dirx4*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall4+speedBall4+radiusBall4)>126 | (yBall4-speedBall4-radiusBall4)<=1){           // if ball reaches the top or bottom corner, we invert moving direction 
    diry4= diry4*(-1);                                         // Invert the moving direction by multiplying by -1
   }                       
}

/**********************************************************************************/
/**********************************************************************************/
/**********************************************************************************/
int main() { 
  lcd.reset();                    //physically reset MINISMARTGPU
  lcd.start();                    //initialize the MINISMARTGPU processor
  wait_ms(200);

  lcd.baudChange(1000000); //set a fast baud! for fast drawing
  lcd.drawRectangle(0,0,159,127,MAGENTA,UNFILL); //draw corners
  
  while(1){             // Loop forever
    moveBall1();        // move ball1
    moveBall2();        // move ball2
    moveBall3();        // move ball3
    moveBall4();        // move ball4
    wait_ms(15);        // wait a little
  }
}
