/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/#!smartgpu-2/c1rc2
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

// defines for balls
#define RADIUSBALL1 15     //ball1 size
#define COLOURBALL1 GREEN  //ball1 colour
#define RADIUSBALL2 8      //ball2 size
#define COLOURBALL2 YELLOW //ball2 colour
#define RADIUSBALL3 11     //ball3 size
#define COLOURBALL3 RED    //ball3 colour
#define RADIUSBALL4 18     //ball4 size
#define COLOURBALL4 BLUE   //ball4 colour

//variables used by move ball methods
int speedBall1=3; //ball1 moving speed - amount of pixels that ball move each time
int speedBall2=4; //ball2 moving speed - amount of pixels that ball move each time 
int speedBall3=8; //ball3 moving speed - amount of pixels that ball move each time 
int speedBall4=6; //ball4 moving speed - amount of pixels that ball move each time 
int dirx1=1;      //xball1 initial positive direction
int diry1=1;      //yball1 initial positive direction
int xBall1=300;   //x initial position of ball1
int yBall1=100;   //y initial position of ball1
int dirx2=-1;     //xball2 initial negative direction
int diry2=-1;     //yball2 initial negative direction
int xBall2=30;    //x initial position of ball2
int yBall2=80;    //y initial position of ball2
int dirx3=-1;     //xball3 initial negative direction
int diry3=1;      //yball3 initial negative direction
int xBall3=60;    //x initial position of ball3
int yBall3=15;    //y initial position of ball3
int dirx4=1;      //xball4 initial negative direction
int diry4=-1;     //yball4 initial negative direction
int xBall4=150;   //x initial position of ball4
int yBall4=80;    //y initial position of ball4

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

/***************************************************/
//Function that updates the current position of the ball1
void moveBall1(){
   lcd.drawCircle(xBall1,yBall1,RADIUSBALL1,BLACK,UNFILL);       // Erase previous ball position
   xBall1+=(dirx1*speedBall1);                                   // Calculate new x coordinate for ball1 
   yBall1+=(diry1*speedBall1);                                   // Calculate new y coordinate for ball1  
   lcd.drawCircle(xBall1,yBall1,RADIUSBALL1,COLOURBALL1,UNFILL); // Draw new ball position
   if((xBall1+speedBall1+RADIUSBALL1)>318 | (xBall1-speedBall1-RADIUSBALL1)<=1){           // if ball reaches the left or right corner, we invert moving direction 
    dirx1= dirx1*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall1+speedBall1+RADIUSBALL1)>238 | (yBall1-speedBall1-RADIUSBALL1)<=1){           // if ball reaches the top or bottom corner, we invert moving direction 
    diry1= diry1*(-1);                                         // Invert the moving direction by multiplying by -1
   }                       
}

/***************************************************/
//Function that updates the current position of the ball2
void moveBall2(){                    
   lcd.drawCircle(xBall2,yBall2,RADIUSBALL2,BLACK,FILL);       // Erase previous ball position
   xBall2+=(dirx2*speedBall2);                                 // Calculate new x coordinate for ball2
   yBall2+=(diry2*speedBall2);                                 // Calculate new y coordinate for ball2  
   lcd.drawCircle(xBall2,yBall2,RADIUSBALL2,COLOURBALL2,FILL); // Draw new ball position
   if((xBall2+speedBall2+RADIUSBALL2)>318 | (xBall2-speedBall2-RADIUSBALL2)<=1){  // if ball reaches the left or right corner, we invert moving direction
    dirx2= dirx2*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall2+speedBall2+RADIUSBALL2)>238 | (yBall2-speedBall2-RADIUSBALL2)<=1){  // if ball reaches the top or bottom corner, we invert moving direction 
     diry2= diry2*(-1);                                        // Invert the moving direction by multiplying by -1
   }                        
}

/***************************************************/
//Function that updates the current position of the ball3
void moveBall3(){                    
   lcd.drawCircle(xBall3,yBall3,RADIUSBALL3,BLACK,FILL);       // Erase previous ball position
   xBall3+=(dirx3*speedBall3);                                 // Calculate new x coordinate for ball3
   yBall3+=(diry3*speedBall3);                                 // Calculate new y coordinate for ball3  
   lcd.drawCircle(xBall3,yBall3,RADIUSBALL3,COLOURBALL3,FILL); // Draw new ball position
   if((xBall3+speedBall3+RADIUSBALL3)>318 | (xBall3-speedBall3-RADIUSBALL3)<=1){  // if ball reaches the left or right corner, we invert moving direction
    dirx3= dirx3*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall3+speedBall3+RADIUSBALL3)>238 | (yBall3-speedBall3-RADIUSBALL3)<=1){  // if ball reaches the top or bottom corner, we invert moving direction 
     diry3= diry3*(-1);                                        // Invert the moving direction by multiplying by -1
   }                        
}

/***************************************************/
//Function that updates the current position of the ball4
void moveBall4(){
   lcd.drawCircle(xBall4,yBall4,RADIUSBALL4,BLACK,UNFILL);       // Erase previous ball position
   xBall4+=(dirx4*speedBall4);                                   // Calculate new x coordinate for ball4 
   yBall4+=(diry4*speedBall4);                                   // Calculate new y coordinate for ball4  
   lcd.drawCircle(xBall4,yBall4,RADIUSBALL4,COLOURBALL4,UNFILL); // Draw new ball position
   if((xBall4+speedBall4+RADIUSBALL4)>318 | (xBall4-speedBall4-RADIUSBALL4)<=1){           // if ball reaches the left or right corner, we invert moving direction 
    dirx4= dirx4*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall4+speedBall4+RADIUSBALL4)>238 | (yBall4-speedBall4-RADIUSBALL4)<=1){           // if ball reaches the top or bottom corner, we invert moving direction 
    diry4= diry4*(-1);                                         // Invert the moving direction by multiplying by -1
   }                       
}

/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}

/***************************************************/
/***************************************************/
/***************************************************/
/***************************************************/
int main() {
  
  initializeSmartGPU2();             //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD6);             //set a fast baud! for fast drawing
  lcd.drawRectangle(0,0,319,239,MAGENTA,UNFILL); //draw corners
  
  while(1){             // Loop forever
    moveBall1();        // move ball1
    moveBall2();        // move ball2
    moveBall3();        // move ball3
    moveBall4();        // move ball4
    wait_ms(15);        // wait a little
  }
}