/*********************************************************
VIZIC TECHNOLOGIES. COPYRIGHT 2012.
THE DATASHEETS, SOFTWARE AND LIBRARIES ARE PROVIDED "AS IS." 
VIZIC EXPRESSLY DISCLAIM ANY WARRANTY OF ANY KIND, WHETHER 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
OR NONINFRINGEMENT. IN NO EVENT SHALL VIZIC BE LIABLE FOR 
ANY INCIDENTAL, SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, 
LOST PROFITS OR LOST DATA, HARM TO YOUR EQUIPMENT, COST OF 
PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, 
ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO 
ANY DEFENCE THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION,
OR OTHER SIMILAR COSTS.
*********************************************************/
/**************************************************************************************/
/*MINI SMARTGPU intelligent embedded graphics processor unit
 those examples are for use the MINI SMARTGPU with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://vizictechnologies.com/#/mini-smart-gpu/4566376187
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2012*/
/**************************************************************************************/
/**************************************************************************************/
 
#include "mbed.h"
#include "MINISMARTGPU.h"

MINISMARTGPU lcd(p13,p14,p15);        //(TX,RX,Reset); Create Object "lcd"

// defines for balls
#define radiusBall1 7     //ball1 size
#define colourBall1 RED    //ball1 colour

//variables used by move ball method
int speedBall1=2; //ball1 moving speed - amount of pixels that ball move each time
int dirx1=1;      //xball1 initial positive direction
int diry1=-1;     //yball1 initial negative direction
int xBall1=80;    //x initial position of ball1
int yBall1=60;    //y initial position of ball1

/***************************************************/
//Function that updates the current position of the ball1
void moveBall1(){
   lcd.drawCircle(xBall1,yBall1,radiusBall1,BLACK,FILL);       // Erase previous ball position
   xBall1+=(dirx1*speedBall1);                                 // Calculate new x coordinate for ball1 
   yBall1+=(diry1*speedBall1);                                 // Calculate new y coordinate for ball1  
   lcd.drawCircle(xBall1,yBall1,radiusBall1,colourBall1,FILL); // Draw new ball position
   if((xBall1+speedBall1+radiusBall1)>158 | (xBall1-speedBall1-radiusBall1)<=1){           // if ball reaches the left or right corner, we invert moving direction 
    dirx1= dirx1*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall1+speedBall1+radiusBall1)>126 | (yBall1-speedBall1-radiusBall1)<=1){           // if ball reaches the top or bottom corner, we invert moving direction 
    diry1= diry1*(-1);                                         // Invert the moving direction by multiplying by -1
   }                       
}

/**********************************************************************************/
/**********************************************************************************/
/**********************************************************************************/
int main() { 
  lcd.reset();                    //physically reset MINISMARTGPU
  lcd.start();                    //initialize the MINISMARTGPU processor
  wait_ms(200);

  lcd.baudChange(1000000); //set a fast baud! for fast drawing
  lcd.drawRectangle(0,0,159,127,YELLOW,UNFILL); //draw corners
  
  while(1){             // Loop forever
    moveBall1();        // move ball1
    wait_ms(15);          // wait a little
  }
}
