/**************************************************************************************/
/*SMARTGPU intelligent embedded graphics processor unit
 those examples are for use the SMARTGPU with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/#/desarrollo/4554296549
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2011 */
/**************************************************************************************/
/**************************************************************************************/
 
#include "mbed.h"
#include "SMARTGPU.h"

SMARTGPU lcd(p13,p14,p15);          //(TX,RX,Reset);

// defines for balls
#define radiusBall1 10              //ball1 size
#define colourBall1 BLUE            //ball1 colour

//variables used by move ball method
int speedBall1=3; //ball1 moving speed - amount of pixels that ball move each time
int dirx1=1;      //xball1 initial positive direction
int diry1=-1;     //yball1 initial negative direction
int xBall1=300;   //x initial position of ball1
int yBall1=100;   //y initial position of ball1

/***************************************************/
//Function that updates the current position of the ball1
void moveBall1(){
   lcd.drawCircle(xBall1,yBall1,radiusBall1,BLACK,FILL);       // Erase previous ball position
   xBall1+=(dirx1*speedBall1);                                 // Calculate new x coordinate for ball1 
   yBall1+=(diry1*speedBall1);                                 // Calculate new y coordinate for ball1  
   lcd.drawCircle(xBall1,yBall1,radiusBall1,colourBall1,FILL); // Draw new ball position
   if((xBall1+speedBall1+radiusBall1)>318 | (xBall1-speedBall1-radiusBall1)<=1){           // if ball reaches the left or right corner, we invert moving direction 
    dirx1= dirx1*(-1);                                         // Invert the moving direction by multiplying by -1
   }
   if((yBall1+speedBall1+radiusBall1)>238 | (yBall1-speedBall1-radiusBall1)<=1){           // if ball reaches the top or bottom corner, we invert moving direction 
    diry1= diry1*(-1);                                         // Invert the moving direction by multiplying by -1
   }                       
}

int main() { 
  lcd.reset();                       //physically reset SMARTGPU
  lcd.start();                       //initialize the SMARTGPU processor
  
  lcd.baudChange(1000000);           //set a fast baud! for fast drawing
  lcd.drawRectangle(0,0,319,239,YELLOW,UNFILL); //draw corners
  
  while(1){             // Loop forever
    moveBall1();        // move ball1
    wait_ms(15);        // wait a little
  }
}
