#include "mbed.h"
//#include "mbed_rpc.h"
#include "SerialRPCInterface.h"
#include "uLCD_4DGL.h"

SerialRPCInterface pc(USBTX, USBRX);

uLCD_4DGL lcd(p28,p27,p30);

void printToLcd(Arguments *in, Reply *out);

RPCFunction rpcPrintToLcd(&printToLcd, "printToLcd");

int main() {
    lcd.cls();

    while (1) {
        wait(0.1);
    }
}

void printToLcd(Arguments *in, Reply *out) {
    const char* str = in->getArg<const char*>();
    lcd.printf("%c", str);
}