#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include "RGBLed.h"
#include "Color.h"

#define _pink Color(255.0, 0.0, (119.0/255.0))
#define _red Color(255.0, 0.0, (119.0/255.0))
#define _orange Color(255.0/255.0, 98.0/255.0, 0.0)
#define _yellow Color(255.0/255.0, 166.0/255.0, 0.0)
#define _light_green Color(187.0/255.0, 255.0/255.0, 0.0)
#define _green Color(17.0/255.0, 201.0/255.0, 0.0)
#define _teal Color(0.0, 255.0/255.0, 170.0/255.0)
#define _light_blue Color(0.0, 255.0/255.0, 247.0/255.0)
#define _blue Color(0.0, 128.0/255.0, 255.0/255.0)
#define _purple Color(106.0/255.0, 0.0, 255.0/255.0)

RGBLed led = RGBLed(p21, p22, p23);

Color colors[] = { _red, _pink, _orange, _yellow };

void led_handler() {
//    Color colors[] = { _red, _pink, _orange, _yellow };
    
    Color c = colors[0];
    int i = 0;
    while (1) {
//        led.write(c.red, c.green, c.blue);
        //i = (i + 1) % 4;
//        Color colors[] = { _red, _pink, _orange, _yellow };
        led.write(1.0, 1.0, 1.0);
        
        Thread::wait(500);
    }
}

SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut DACout(p18);
wave_player waver(&DACout);

void audio_handler() {
    FILE *wave_file;
    printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/sample.wav","r");
    while (1) {
        waver.play(wave_file);
        Thread::wait(1);
    }
    fclose(wave_file);
}

Mutex lcd_mutex;
uLCD_4DGL lcd(p28,p27,p30);

void lcd1_handler() {
    int i = 0;
    while (1) {
        lcd_mutex.lock();
        lcd.locate(0, 0);
        lcd.printf("Elapsed time: %d s", i);
        lcd_mutex.unlock();
        
        i++;
        Thread::wait(1000);
    }
}

void lcd2_handler() {
    while (1) {
        lcd_mutex.lock();
        
        lcd_mutex.unlock();
        Thread::wait(0);
    }
}

void changeColor(char c) {
    if (c == 'r') {
        colors[0] = _red;
        colors[1] = _pink;
        colors[2] = _orange;
        colors[3] = _yellow;
    } else if (c == 'b') {
        colors[0] = _teal;
        colors[1] = _light_blue;
        colors[2] = _blue;
        colors[3] = _purple;
    } else if (c == 'g') {
        colors[0] = _yellow;
        colors[1] = _light_green;
        colors[2] = _green;
        colors[3] = _teal;
    }
}

Thread led_thread, audio_thread, lcd1_thread, lcd2_thread;


void run_part4() {
    led_thread.start(led_handler);
//    audio_thread.start(audio_handler);
//    lcd1_thread.start(lcd1_handler);
//    lcd2_thread.start(lcd2_handler);
    
    //while (1) {
//        if (dev.readable()) {
//            changeColor(dev.getc());
//        }
//    }
    while (1) ;
            
}